/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/word.h"
#include "aum/derive.h"
#include "aum/error.h"
#include "aum/object.h"
#include "aum/localmsg.h"
#include "aum/send.h"
#include "builtin/extern.h"
#include "class/template.h"
#include "class/clink.h"

Word
CallAUmProgram (FPWord_Word make, const ProtocolID& pid, Word ax, Word ay)
{
    doSplit (ax);
    Word object = (*make) (ax);
    Word z = SendBuiltinMessage2 (object, pid, ay);
    doClose (object);
    return z;
}

Word
CreateSuperObject (ClassInfo** super, const char* pname, Word builtin_object)
    // {}
    // ȹ饹Ǽ館ʤ A'Um ֥Υ󥹥󥹥
    // ֥Ȥޤ롥ǽ pname Υ饹
    // Ƥ뤫Ĵ٤롥ɤƤʤˤϥ顼Ȥƽ
    // λ롥 饹 pname Υ󥹥󥹥֥Ȥ
    // initialize/+ å롥ȹ饹Υ󥹥󥹥
    // ֥ȤǤ롥㤨Сʸξˤ initialize("xyz") 
    // ͤʥå롥Ǹˡ󥹥󥹥֥
    // ֤
    // {}
{
    if (!*super)
	*super = Find_class_info (pname);
    if (!*super)
	error (pname, "Library \"derive.aao\" has't been loaded");
    Word object = Create_local_instance (*super);
    LocalMessage* lm = new_LocalMessage (1, PID_INITIALIZE1);
    lm->Argv (0, builtin_object);
    doSend (object, lm);
    return object;
}

Word
CreateSuperStringObject (Word builtin_object)
{
    static ClassInfo* super_string;
    return CreateSuperObject (&super_string, "super_string", builtin_object);
}

Word
CreateSuperDoubleObject (Word builtin_object)
{
    static ClassInfo* super_double;
    return CreateSuperObject (&super_double, "super_double", builtin_object);
}

Word
CreateSuperListObject (Word builtin_object)
{
    static ClassInfo* super_list;
    return CreateSuperObject (&super_list, "super_list", builtin_object);
}

Word
CreateSuperVectorObject (Word builtin_object)
{
    static ClassInfo* super_vector;
    return CreateSuperObject (&super_vector, "super_vector", builtin_object);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
