/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"

#include <assert.h>
#include "aum/fetch.h"
#include "aum/global.h"
#include "aum/builtin.h"
#include "aum/joint.h"
#include "aum/j-c.h"
#include "aum/close.h"
#include "aum/connect.h"
#include "aum/error.h"
#include "aum/stdlib.h"
#include "aum/globlmsg.h"
#include "aum/string.h"
#include "builtin/extern.h"

static void local_object_copy (const Word ax, J_NC_t* ay);
static void global_object_copy (const Word ax, J_NC_t* ay);
static GlobalMessage* Iam_copy_DFloat (Word);
static GlobalMessage* Iam_copy_ASCII_String (Word);
static GlobalMessage* Iam_copy_EUC_String (Word);
static void copy_is_not_supported (Word);

void
doCopy (const Word ax, const Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS  object
    // {} @ NOTATION X:copy(^Y)
    // {} @ EXPLANATION
    // Xʣ̤ƿ֥Ȥ, ȥ꡼ Y ³롥
    // XYƱȤʤ롥СǤ󡤥ꥹȡ
    // ֥ȤΥԡϥݡȤƤʤ
    // {} @ METHOD END
{
    assert (IsInlet (ay) == TRUE);
    Word x = ax;
    J_NC_t* y = J_NC_ptr (ay);

 case_retry:
    switch (Type_of (x)) {
    case AUm_Fixnum:
    case AUm_Atom:
	doConnect (x, y);
	return;
    case AUm_Object:
	switch (Pointer (x)->oTag ()) {
	case DFLOAT:
	case ASCII_STR:
	case EUC_STR:
	    switch (Pointer (ay)->oTag ()) {
	    case JOINT:
		local_object_copy (x, y);
		return;
	    case IMP_INLET:
		global_object_copy (x, y);
		return;
	    default:
		abort ();
	    }
	    return;
	case JOINT:
	    goto case_retry;
	default:
	    copy_is_not_supported (x);
	}
	return;
    default:
	if (IsSFloat (x) || IsBool (x))
	    doConnect (x, y);
	else if (IsSink (x))
	    doConnect (SINKOBJ, y);
	else
	    copy_is_not_supported (x);
	return;
    }
}

METHOD (copy, R2_OP)
    // {}
    // copy Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // Ri  ԡʪ Rj ³롥Rj üǤʤƤϤʤ
    // 
    // {}
{
    Fetch4 ();
    const Word ax = Reg[ip->b0];
    const Word ay = Reg[ip->b1];
    doCopy (ax, ay);
    /* NO! close; see below functions, use in connect () ; doClose (ax); */
    JumpNextInstruction ();
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

static void
local_object_copy (const Word ax, J_NC_t* ay)
{
    assert (IsObject (ax));
    Word x = Dereference (ax);
    Word z;
    switch (Pointer (x)->oTag ()) {
    case DFLOAT:
	z = CopyDFloat (x);
	break;

    case ASCII_STR:
	z = CopyASCIIString (x);
	break;

    case EUC_STR:
	z = CopyEUCString (x);
	break;

    case JOINT:
    case OBJECT:
    case IMPORTED_OBJECT:
	Sendm_1arg (x, PID_COPY, ObjectWord (ay));
	return;

    default:
	copy_is_not_supported (x);
	return;
    }
    doConnect (z, ay);
}

static void
global_object_copy (const Word ax, J_NC_t* ay)
{
    assert (IsObject (ax));
    Word x = Dereference (ax);
    GlobalMessage* gm;
    switch (Pointer (x)->oTag ()) {
    case DFLOAT:
	gm = Iam_copy_DFloat (x);
	break;

    case ASCII_STR:
	gm = Iam_copy_ASCII_String (x);
	break;

    case EUC_STR:
	gm = Iam_copy_EUC_String (x);
	break;

    case JOINT:
    case OBJECT:
    case IMPORTED_OBJECT:
	Sendm_1arg (x, PID_COPY, ObjectWord (ay));
	return;

    default:
	copy_is_not_supported (x);
	return;
    }
    ImportTable->Delete ((MJ_IMP_t *) ay);
    send_to_other_pe (((MJ_IMP_t *)ay)->GID (), gm);
}

static void
copy_is_not_supported (Word x)
{
    error (form("%s:copy(^Y)",print (x)),CAN_NOT_FIND_METHOD,"copy/-");
}

GlobalMessage*
Iam_copy_DFloat (Word ax)
{
    assert (IsDFloat (ax));
    void* ptr = DFloatObject_ptr (ax);
    int nbytes = sizeof (DFloatObject);
    GlobalMessage* gm = new_Iam_copy (DFLOAT, ptr, nbytes);
    return gm;
}

GlobalMessage*
Iam_copy_ASCII_String (Word ax)
{
    assert (IsASCII_StrObject (ax));
    ASCII_StrObject* ptr = ASCII_StrObject_ptr (ax);
    int nbytes = ptr->no_of_bytes ();
    GlobalMessage* gm = new_Iam_copy (ASCII_STR, ptr, nbytes);
    return gm;
}

GlobalMessage*
Iam_copy_EUC_String (Word ax)
{
    assert (IsEUC_StrObject (ax));
    EUC_StrObject* ptr = EUC_StrObject_ptr (ax);
    int nbytes = ptr->no_of_bytes ();
    GlobalMessage* gm = new_Iam_copy (EUC_STR, ptr, nbytes);
    return gm;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * End:
 */
