/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/stdlib.h"
#include "aum/connect.h"
#include "aum/object.h"
#include "aum/fetch.h"
#include "aum/error.h"
#include "aum/aj-c.h"
#include "aum/aj-nc.h"
#include "aum/mj-c.h"
#include "aum/mj-nc.h"
#include "aum/mj-imp.h"
#include "aum/parallel.h"

#ifdef PAS_DEBUGGER
#include "class/template.h"
#include "aum/tstream.h"
#endif

// use for error message
static char CONNECT[] = "connect";

static void
fatal_in_connect (Word tail, const char *string)
{
    fatal (form ("%s %s", CONNECT, print (tail)), string);
}

void
connect_arg_not_joint (Word tail, Header * head)
{
    fatal_in_connect (tail, "2nd argument is not a joint");
}

void
connect_arg_already_connected (Word tail, Header * head)
{
    fatal_in_connect (tail, "2nd argument is already connected joint");
}


void
doConnect (Word & tail, J_NC_t * head)
    // {*} @ METHOD BEGIN
    // {*} @ CLASS  atom string
    // {*} @ NOTATION  X = ^Z
    // {*} @ EXPLANATION
    // ̤³(³ޤäƤʤä)祤(head), ³ˤ
    // , ޤαƤå³(tail)ž.  
    // ³褬 MJ_C 뤤 MJ_Mut ʤФ³򿷤ʤ³
    // (dereference)³η̡head, tail λȲȤʤ
    // ΰ롥
    // {*} @ METHOD END
{
    Boolean structure_p;

retry:
    switch (Type_of (tail)) {
    case AUm_Object:
	switch (Pointer (tail)->Type ()) {
	case MJ_C:
	    tail = MJ_C_ptr (tail)->Dereference ();
	    goto retry;

	case MJ_Mut:
	    tail = MJ_Mut_ptr (tail)->Dereference ();
	    goto retry;

	case AJ_C:
	    AJ_C_ptr (tail)->Connect (head);
	    return;

	case MJ_NC:
	    if (J_NC_ptr (tail) == head) {
		fatal_in_connect (tail, "cyclic structure");
	    }
	    /* no break */
	case MJ_W:
	    MJ_NC_ptr (tail)->Connect (head);
	    return;

	case AJ_NC:
	    AJ_NC_ptr (tail)->Connect (head);
	    return;

	case IMP_OUTLET:
	    MJ_IMP_OUTLET_ptr (tail)->Connect (head);
	    return;

	case IMP_OBJ_NT:
	    MJ_IMP_OBJ_NT_ptr (tail)->Connect (head);
	    return;

	case IMP_OBJ:
	    MJ_IMP_OBJ_ptr (tail)->Connect (head);
	    return;

	case READY:
	case SUSPENDED:
	    Object_ptr (tail)->Connect (head);
	    return;

	case SLEEPING:
	    Object_ptr (tail)->Connect_and_Schedule (head);
	    return;

	case CLOSED:
	    fatal_in_connect (tail, "1st argument has been closed");
	    return;

	default:
	    fatal_in_connect (tail, "1st argument has invalid object-tag");
	    return;

	case ASCII_STR:
	case DFLOAT:
	case ERROR:
	case EUC_STR:
	case FILE_STREAM:
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	case MESSAGE_OBJ:
	case FOREIGN_OBJ:
	case SINK:
	case VECTOR:
	case WC_ASCII_STR:
	case WC_EUC_STR:
	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	case WC_VECTOR:
	    break;
	}
	structure_p = TRUE;
	break;

    case AUm_Fixnum:
    case AUm_Atom:
    default:
	structure_p = FALSE;
	break;
    }

    // ȥߥå֥Ȥؤ³

    switch (head->Type ()) {
    case MJ_NC:
	if (((MJ_NC_t *) head)->MessageExist () == TRUE) {
	    if (structure_p)
		((MJ_NC_t *) head)->Reached_structure (tail);
	    else
		((MJ_NC_t *) head)->Reached_atomic (tail);
	}
	if (head->LRC () == 1) {
	    ((MJ_NC_t *) head)->Free ();
	    if (structure_p)
		doClose (tail);
	}
	else {
	    head->LRC () -= 1;
	    ((MJ_NC_t *) head)->mut2_MJ_C (tail);
	}
	return;
    case AJ_NC:
	if (((AJ_NC_t *) head)->MessageExist () == TRUE) {
	    if (structure_p)
		((AJ_NC_t *) head)->Reached_structure (tail);
	    else
		((AJ_NC_t *) head)->Reached_atomic (tail);
	}
	if (head->LRC () == 1) {
	    doConnect (tail, ((AJ_C_t *) head)->Next_joint ());
	    ((AJ_NC_t *) head)->Free ();
	    if (structure_p)
		doClose (tail);
	}
	else {
	    head->LRC () -= 1;
	    ((AJ_NC_t *) head)->mut2_AJ_C (tail);
	}
	return;

    case IMP_INLET:
	if (structure_p)
	    ((MJ_IMP_INLET_t *) head)->Forward_IamHere_GRC (Pointer (tail));
	else
	    ((MJ_IMP_INLET_t *) head)->ExecuteMessage (tail);
	return;

    case MJ_C:
    case AJ_C:
    case MJ_W:
    case IMP_OBJ:
    case IMP_OBJ_NT:
    case IMP_OUTLET:
	connect_arg_already_connected (tail, head);
	return;

    default:
	fatal_in_connect (tail, "2nd argument is not a joint");
    }
}


METHOD (connect, R2_OP)
    // {}
    // connect Ri,Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // 祤 Rj 򥪥֥ Ri ³롥Rj αƤ
    //  Ri ž.
    // {}
{
    Fetch112 ();

    if (PAS_message_may_be_received) {
#ifdef PAS_DEBUGGER
	if (global_message_queue)
	    Receive_SystemMessage(global_message_queue);
	global_message_queue = (GlobalMessage*)0;
#endif
	GlobalMessage *message = PAS_receive_in_nonblocking ();
	if (message)
	    Receive_SystemMessage (message);
    }

#ifdef PAS_DEBUGGER
    extern void is_enter_break_loop_connect(Word x,Word y);
    is_enter_break_loop_connect(Reg[ip->b0],Reg[ip->b1]);
    if (next_step){
	next_step = FALSE;
    } else {
	if (stop){
	    BREAK_LOOP;
	}
    }
#endif
#ifndef NDEBUG
    if (!IsPointer (Reg[ip->b1])) {
	fatal (CONNECT, "2nd register R%d is not a joint", ip->b1);
    }
#endif
    doConnect (Reg[ip->b0], (J_NC_t *) Pointer (Reg[ip->b1]));
    JumpNextInstruction ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
