/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/stdlib.h"
#include "aum/close.h"
#include "aum/scheduler.h"
#include "aum/object.h"
#include "aum/builtin.h"
#include "aum/vector.h"
#include "aum/msgobj.h"
#include "aum/list.h"
#include "aum/string.h"
#include "aum/aj-c.h"
#include "aum/aj-nc.h"
#include "aum/mj-c.h"
#include "aum/mj-nc.h"
#include "aum/mj-imp.h"
#include "aum/fetch.h"
#include "aum/trace.h"
#include "aum/fstream.h"

void
doClose_object (Word word)
    // {}
    // word ɽ륪֥Ȥ뤤ϥ祤Ȥĺ.
    //
    // μ̤֥Ȥξ:
    // ֥ȤλȲ򣱸餹֥Ȥ塼ɽ
    // ϿƤʤä顤塼ɽϿ롥
    //
    // 祤Ȥξ:
    // 祤ȤλȲ򣱸餹³褬ꤷƤơΥ
    // ȤФ¾ԤʤС祤Ȥ롥
    //
    // ȹ֥Ȥξ:
    // ¾ԤϤʤʤСĺ¹Ԥ롥
    //
    // ¾ξ:
    // ⤷ʤ
    // {}
{
    if (Trace->doit ())
	Trace->BeginClose (print (word));

retry:
    if (IsObject (word) == TRUE) {
	// {}
	// ¤ǡǤΤߡȥȤιԤʤ
	// {}

	switch (Pointer (word)->Type ()) {
	case MJ_C:
	    word = MJ_C_ptr (word)->Dereference ();
	    goto retry;

	case MJ_Mut:
	    word = MJ_Mut_ptr (word)->Dereference ();
	    goto retry;

	case AJ_C:
	    Pointer (word)->LRC_plus (-1);
	    if (Pointer (word)->LRC () == 0) {
		doConnect (AJ_C_ptr (word)->Destination (),
			   AJ_C_ptr (word)->Next_joint ());
		AJ_C_ptr (word)->Free ();
	    }
	    break;

	case MJ_NC:
	case MJ_W:
	case AJ_NC:
	    Pointer (word)->LRC_plus (-1);
#ifndef NDEBUG
	    if (Object_ptr (word)->LRC () == 0) {
		// {}
		// INLET ïäƤϤ
		// ȥȤ 0 ˤʤˡSINK/ERRORˤ줫
		// ³Ƥ
		// {}
		fatal (form("%s:close",print (word)),"unbalanced LRC");
	    }
#endif /* NDEBUG */
	    break;

	case READY:
	case SUSPENDED:
	    Pointer (word)->LRC_plus (-1);
	    break;

	case SLEEPING:
	    Pointer (word)->LRC_plus (-1);
	    if (Pointer (word)->LRC () == 0) {
		// {}
		// ȥȤ0ȤʤäΤǡ塼ˤΤ
		// {}
		Object_ptr (word)->doCLOSED ();
		ScheduleTable.Register (Object_ptr (word));
	    }
	    break;

	case SINK:
	case ERROR:
	    if (--Pointer (word)->LRC () == 0) {
		Object_ptr (word)->Free ();
	    }
	    break;

	case IMP_OBJ_NT:
	case IMP_OBJ:
	case IMP_OUTLET:
	    if (--MJ_IMP_ptr (word)->LRC () == 0) {
		MJ_IMP_ptr (word)->Close ();
		MJ_IMP_ptr (word)->Free ();
	    }
	    break;
	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	    if (--ListObject_ptr (word)->LRC () == 0) {
		ListObject_ptr (word)->Close ();
		ListObject_ptr (word)->Free ();
	    }
	    break;
	case VECTOR:
	case WC_VECTOR:
	    if (--VectorObject_ptr (word)->LRC () == 0) {
		VectorObject_ptr (word)->Close ();
		VectorObject_ptr (word)->Free ();
	    }
	    break;

	case WC_MESSAGE_OBJ:
	case MESSAGE_OBJ:
	    if (--MessageObject_ptr (word)->LRC () == 0) {
		MessageObject_ptr (word)->Free ();
	    }
	    break;

	case FOREIGN_OBJ:
	    if (--ForeignObject_ptr (word)->LRC () == 0) {
		ForeignObject_ptr (word)->Free ();
	    }
	    break;

	case WC_ASCII_STR:
	case ASCII_STR:
	    if (--ASCII_StrObject_ptr (word)->LRC () == 0) {
		ASCII_StrObject_ptr (word)->Free ();
	    }
	    break;

	case WC_EUC_STR:
	case EUC_STR:
	    if (--EUC_StrObject_ptr (word)->LRC () == 0) {
		EUC_StrObject_ptr (word)->Free ();
	    }
	    break;

	case DFLOAT:
	    if (--DFloatObject_ptr (word)->LRC () == 0) {
		DFloatObject_ptr (word)->Free ();
	    }
	    break;

	case FILE_STREAM:
	    if (--FileStreamObject_ptr (word)->LRC () == 0) {
		FileStreamObject_ptr (word)->Free ();
	    }
	    break;

	default:
	    fatal ("close", "unknown object tag");
	}
    } /* if */
    if (Trace->doit ())
	Trace->EndClose (print (word));
}

METHOD (close, R1_OP)
    // {}
    // close Ri
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // {}
    // Ri ɽ륪֥Ȥ뤤ϥ祤Ȥĺ.
    // {}
{
    Fetch112 ();
    doClose (Reg[ip->b0]);
    JumpNextInstruction ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
