/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/mj-c.h"
#include "aum/fetch.h"
#include "aum/close.h"

void
doBranch_on_who (Word ax, const u_short size)
    // {}
    // ֥ x ȥߥå֥Ȥλϡб٥
    // Хɥ쥹֤⤷ x ΰ褬ꤷƤʤϡ
    // ̿ؤХɥ쥹 next ֤
    // {}
{
    Word    x = ax;

    if (TraceMessage)
	mlog_mon ("branch", x);

    retry:
    switch (Type_of (x)) {
    default:
	if (!IsBool (x) && !IsSFloat (x))
	    break;
	/* no break */

    case AUm_Fixnum:
    case AUm_Atom:
	{
	    register int n = size;
	    Word   *p = (Word *) (InstructionPointer + 2);
	    while (--n >= 0) {
		if (x == *p++) {
		    InstructionPointer += *p;
		    doClose (ax);
		    return;
		}
		p++;
	    }
	}
	break;

    case AUm_Object:
	switch (Pointer (x)->oTag ()) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;
	default:
	    break;
	}
	break;
    }
    InstructionPointer += size * 2 + sizeof (struct b2s1) / sizeof (Instruction);
}

METHOD (branch_on_who, R1Xe_OP)
    // {}
    // branch_on_who Ri, Vn;
    // {}
    // [	   address ]
    // [  Ri|	0|	 Vn]
    // [		 V1]
    // [		 L1]
    // [   ...		   ]
    // [		 Vi]
    // [		 Li]
    // {}
    // ֥ Ri ȥߥå֥ȤʤСб٥
    // ʬ롥 Ǥʤˤϲ⤷ʤ
    // {}
{
    Fetch112 ();
    doBranch_on_who (Reg[ip->b0], ip->s0);
    DO_TRACE_INSTRUCTION;
    JUMPNEXT;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
