/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/stdlib.h"
#include "aum/aj-nc.h"
#include "aum/aj-c.h"
#include "aum/fetch.h"
#include "aum/alloc.h"
#include "aum/allocstats.h"
#include "aum/parallel.h"

// #define ALLOC_DEBUG 1

#ifdef ALLOC_DEBUG
#include <stream.h>
#endif

static AJ_NC_t *
aj_alloc ()
{
    UPDATE_ALLOC_STATS (aj_alloc);
    AJ_NC_t *aj = (AJ_NC_t *) PRIVATE_ALLOC (sizeof (AJ_NC_t));
#ifdef ALLOC_DEBUG
    pelog ("aj alloc %x", aj);
#endif
    return aj;
}

void
aj_free (void *v)
{
    UPDATE_ALLOC_STATS (aj_free);
#ifdef ALLOC_DEBUG
    pelog ("aj free %x", v);
#endif
    PRIVATE_FREE (v, sizeof (AJ_NC_t));
}

void
AJ_NC_t::Free ()
{
    aj_free (this);
}

void
AJ_C_t::Free ()
{
    aj_free (this);
}

Word
new_Appender (J_NC_t * j)
    // {}
    // ڥݤ롥Υ祤Ȥ j Ϳ롥j ν
    // üǤ³ƤǽΤǡj->LRC () ϣʾ
    // ʤФʤʤ
    // {}
{
    assert (j->LRC () > 0);
    AJ_NC_t *aj = aj_alloc ();
    aj->Initialize (2, j);
    return ObjectWord (aj);
}

METHOD (create_ajoint, R2_OP)
    // {}
    // create_ajoint Ri, Rj;
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // 祤 Rj ĥڥ Ri Ȥ롥
    // {}
{
    Fetch112 ();
    Word    x = Reg[ip->b1];
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case AJ_NC:
	case MJ_NC:
	    Reg[ip->b0] = new_Appender (J_NC_ptr (x));
	    JumpNextInstruction ();
	default:
	    break;
	}
    }
    fatal ("create_ajoint", "2nd argument %s is not a joint", print (x));
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
