/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include "aum/allocstats.h"

#ifdef ALLOC_STATS

AllocStatsClass AllocStats;

void
AllocStatsClass::Report (int on)
{
    if (!on)
	return;

    cerr << "\nAllocation Statistics\n\n";

    if (n_mj_allocs)
	cerr.form("merger joint: alloc = %6u, free = %6u\n",
		  n_mj_allocs, n_mj_frees);

    if (n_aj_allocs)
	cerr.form("append joint: alloc = %6u, free = %6u\n",
		  n_aj_allocs, n_aj_frees);

    if (n_object_allocs)
	cerr.form("object:	 alloc = %6u, free = %6u\n",
		  n_object_allocs, n_object_frees);
}

#endif /* ALLOC_STATS */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
