/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/allocmsg.h"
#include "aum/message.h"
#include "aum/parallel.h"

#ifdef CACHED_ALLOC_MESSAGE

// #define ALLOC_MSG_DEBUG

#ifdef ALLOC_MSG_DEBUG
#define PELOG(s,a,b) { pelog(s,a,b); }
#else
#define PELOG(s,a,b) { }
#endif

#define MAX_NITEM	32
#define toIndex(x)	((x)/sizeof(int))
#define MAXMSIZ		(toIndex(MAX_MESSAGE_SIZE) + 1)

struct mgl {
    struct mgl *chain;
    int	    nitem;
};
typedef struct mgl Mgl;

static Mgl mg_link[MAXMSIZ];

void   *
mg_alloc (unsigned nbytes)
{
    void   *addr;
    if (nbytes <= MAX_MESSAGE_SIZE) {
	Mgl    *mp = &mg_link[toIndex (nbytes)];
	if (mp->chain) {
	    addr = mp->chain;
	    --mp->nitem;
	    mp->chain = mp->chain->chain;
	}
	else
	    addr = SHARED_ALLOC (nbytes);
    }
    else {
	addr = SHARED_ALLOC (nbytes);
    }
    PELOG ("mg alloc %x (%d bytes)", addr, nbytes);
    return addr;
}

void
mg_free (void *addr, unsigned nbytes)
{
    PELOG ("mg free  %x (%d bytes)", addr, nbytes);
    if (nbytes <= MAX_MESSAGE_SIZE) {
	Mgl    *mp = &mg_link[toIndex (nbytes)];
	if (mp->nitem > MAX_NITEM) {
	    SHARED_FREE (addr, nbytes);
	}
	else {
	    ((Mgl *) addr)->chain = mp->chain;
	    mp->chain = addr;
	    mp->nitem++;
	}
    }
    else {
	SHARED_FREE (addr, nbytes);
    }
}

#ifdef PAS_DEBUGGER
void
refresh_mg_link ()
{
    for (int oo = 0; oo < MAXMSIZ; oo++) {
	Mgl    *mp = &mg_link[oo];
	if (mp->nitem > 0) {
	    int	    chain_leng = mp->nitem;
	    for (; chain_leng; chain_leng--) {
		Mgl    *w = mp->chain;
		mp->chain = mp->chain->chain;
		SHARED_FREE (w, oo * sizeof (int));
	    }
	}
	else
	    mp->chain = (Mgl *) 0;
    }
}
#endif				/* PAS_DEBUGGER */

#endif				/* CACHED_ALLOC_MESSAGE */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
