/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/aj-c.h"
#include "aum/aj-nc.h"
#include "aum/connect.h"
#include "aum/mj-c.h"
#include "aum/trace.h"
#include "aum/stdlib.h"

Word
AJ_C_t::Dereference ()
    // {}
    // ʬȤĺ롥̤ȤƻȲȤʤΰ
    // Υ祤Ȥ³롥ʳη̤ʤС³λ
    // Ȳܣ롥δؿΥ꥿͡³ˤ dereference
    // Ѥ롥
    // {}
{
    Word    next = destination;
    if (--h.lrc == 0) {
	doConnect (destination, next_joint);
	Free ();
    }
    else {
	if (IsPointer (next))
	    J_C_ptr (next)->LRC_plus (1);
    }
    return next;
}

void
AJ_C_t::Forward (J_NC_t * head)
{
    if (TraceMessage && head->MessageExist ())
	mlog2 ("Recv", ObjectWord (this));

    for (Message * mp = head->PopMessage (); mp; mp = head->PopMessage ())
	doSend (destination, mp);
}

void
AJ_C_t::Connect (J_NC_t * head)
    // {}
    // head ڥǤʤʤСdoConnect() ƤӽФڥ
    // СΥڥݻƤå destination ž
    // ڥΰʬˤ
    // {}
{
    switch (head->Type ()) {
    case MJ_NC:
	Forward (head);
	if (head->LRC () == 1) {
	    ((MJ_NC_t *) head)->Free ();
	    if (--h.lrc == 0) {
		doConnect (destination, next_joint);
		Free ();
	    }
	}
	else {
	    head->LRC ()--;
	    ((MJ_NC_t *) head)->mut2_MJ_C (ObjectWord (this));
	}
	return;

    case AJ_NC:
	Forward (head);
	if (head->LRC () == 1) {
	    Word aj = ObjectWord (this);
	    doConnect (aj, ((AJ_C_t *) head)->Next_joint ());
	    ((AJ_NC_t *) head)->Free ();
	}
	else {
	    head->LRC ()--;
	    ((AJ_NC_t *) head)->mut2_AJ_C (ObjectWord (this));
	}
	return;

    case IMP_INLET:
	abort ();
	return;

    case MJ_C:
    case AJ_C:
    case MJ_W:
    case IMP_OBJ:
    case IMP_OBJ_NT:
    case IMP_OUTLET:
	connect_arg_already_connected (ObjectWord (this), head);

    default:
	connect_arg_not_joint (ObjectWord (this), head);
    }
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-brace-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * c-imaginary-offset:0
 * c++-electric-colon:t
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
