/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/stdlib.h"
#include "aum/mj-c.h"
#include "aum/object.h"
#include "aum/fetch.h"
#include "aum/proceed.h"

static char ACTIVATE[] = "activate";

void
doActivate (Word parent)
    // {}
    // ̿ wait ˤäƻߤޤäƤƥ֥Ȥ򵯤
    // {}
{
 retry:
    switch (Type_of (parent)) {
    case AUm_Object:
	switch (Object_ptr (parent)->Type ()) {
	case AJ_C:
	case MJ_C:
	case MJ_Mut:
	    parent = J_C_ptr (parent)->Destination ();
	    goto retry;

	case SUSPENDED:
	    Object_ptr (parent)->Scheduling ();
	    return;

	case READY:
	case SLEEPING:
	case CLOSED:
	case ERROR:
	case SINK:
	    fatal (ACTIVATE, "\"%s\" is not waiting", print (parent));
	    return;

	default:
	    fatal (ACTIVATE, "%s is not an object", print (parent));
	    return;

	}
    default:
	fatal (ACTIVATE, "%s is not an object", print (parent));
	return;

    }
}

METHOD (activate, R1_OP)
    // {}
    // activate Ri
    // {}
    // [	   address ]
    // [  Ri|	0|	  0]
    // {}
    // {}
    // ̿ wait ˤäƻߤޤäƤƥ֥ Ri 򵯤
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    doActivate (x);
    doClose (x);
    JumpNextInstruction ();
}

METHOD (wait, NO_OP)
    // {}
    // wait
    // {}
    // [	   address ]
    // {}
    // ̿ activate ˤäƵޤԤġ
    // {}
{
    CurrentObject->doSUSPENDED ();
    Proceed ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
