/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef mathematics_type_h
#define mathematics_type_h

// ѱ黻Ѥʬޥ

enum mathematics_type {
    MT_Fixnum,
    MT_Single,
    MT_Double,
    MT_Joint,
    MT_Connected,
    MT_User,
    MT_Sink,
    MT_Others,
};

inline enum mathematics_type
MathType (Word x)
{
    switch (Type_of (x)) {
    case AUm_Fixnum:
	return MT_Fixnum;
    case AUm_Object:
	switch (Pointer (x)->oTag ()) {
	case CONNECTED:
	    return MT_Connected;
	case DFLOAT:
	    return MT_Double;
	case JOINT:
	case IMPORTED_OBJECT:
	    return MT_Joint;
	case OBJECT:
	    return MT_User;
	default:
	    break;
	}
	return MT_Others;
    case AUm_Atom:
	return MT_Others;
    default:
	if (IsSFloat (x))
	    return MT_Single;
	if (IsSink (x))
	    return MT_Sink;
	break;
    }
    return MT_Others;
}

#endif	/* !mathematics_type_h */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
