/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef mathematics_sub_h
#define mathematics_sub_h

inline Word
FixnumSub (Word& x, Word& y)
{
    return Int2Fix (Fix2Int (x) - Fix2Int (y));
}

inline Word
FixSingleSub (Word& x, Word& y)
{
    return float2Single ((float) Fix2Int (x) - Single2float (y));
}

inline Word
SingleFixSub (Word& x, Word& y)
{
    return float2Single (Single2float (x) - (float) Fix2Int (y));
}

inline Word
SingleFloatSub (Word& x, Word& y)
{
    return float2Single (Single2float (x) - Single2float (y));
}

inline Word
DoubleSingleSub (Word& x, Word& y)
{
    return CreateDFloat (Double2double (x) - (double) Single2float (y));
}

inline Word
SingleDoubleSub (Word& x, Word& y)
{
    return CreateDFloat ((double) Single2float (x) - Double2double (y));
}

inline Word
DoubleFixSub (Word& x, Word& y)
{
    return CreateDFloat (Double2double (x) - (double) Fix2Int (y));
}

inline Word
FixDoubleSub (Word& x, Word& y)
{
    return CreateDFloat ((double) Fix2Int (x) - Double2double (y));
}

inline Word
DoubleFloatSub (Word& x, Word& y)
{
    return CreateDFloat (Double2double (x) - Double2double (y));
}

#endif	/* !mathematics_sub_h */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
