/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"
#include "mathematics/type.h"
#include "mathematics/sub.h"

static const char *
subform (Word x, Word y,const char* name)
{
    return form ("%s :%s(%s,^Z)", print (x),name, print (y));
}

Word
doSub_with_fixnum (Word ax, Word ay)
    // {}
    //  x 饪֥ y , η̤֤x  y 
    // ؿ٤ηۤʤ硤ѴԤʤy ηޤäƤ
    // ʤ祤Ȥξ硤뤤ϥ桼֥Ȥξ硤
    // 롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = FixnumSub (ax, y);
	break;
    case MT_Single:
	z = FixSingleSub (ax, y);
	break;
    case MT_Double:
	z = FixDoubleSub (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_SUB_FIXNUM, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (subform (ax, ay,"rev_sub"),CAN_NOT_FIND_METHOD,"rev_sub/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doSub_with_sfloat (Word ax, Word ay)
    // {}
    // ñư x 饪֥ y , η̤
    // x  y Ρؿ٤ηۤʤ硤ѴԤʤy 
    // ηޤäƤʤ祤Ȥξ硤뤤ϥ桼֥
    // ξ硤å롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = SingleFixSub (ax, y);
	break;
    case MT_Single:
	z = SingleFloatSub (ax, y);
	break;
    case MT_Double:
	z = SingleDoubleSub (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_SUB_SFLOAT, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (subform (ax, ay,"rev_sub"),CAN_NOT_FIND_METHOD,"rev_sub/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doSub_with_dfloat (Word ax, Word ay)
    // {}
    // ư x 饪֥ y , η̤
    // x  y Ρؿ٤ηۤʤ硤ѴԤʤy 
    // ηޤäƤʤ祤Ȥξ硤뤤ϥ桼֥
    // ξ硤å롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = DoubleFixSub (ax, y);
	break;
    case MT_Single:
	z = DoubleSingleSub (ax, y);
	break;
    case MT_Double:
	z = DoubleFloatSub (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_SUB_DFLOAT, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (subform (ax, ay,"rev_sub"),CAN_NOT_FIND_METHOD,"rev_sub/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doSub (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS number
    // {} @ NOTATION X:sub(Y,^Z)
    // {} @ MACRO X - Y = ^Z
    // {} @ EXPLANATION
    // X  Y , η̤򥹥ȥ꡼Z³롥X  Y 
    // ؿ٤ηۤʤ硤ѴԤʤ
    // @send_when_cant_execute{Y}{rev_sub(X,^Z)}
    // {} @ METHOD END
{
    Word    x = ax;
    Word    z;
retry:
    switch (MathType (x)) {
    case MT_Connected:
	x = J_C_ptr (x)->Destination ();
	goto retry;
    case MT_Fixnum:
	return doSub_with_fixnum (x, ay);
    case MT_Single:
	return doSub_with_sfloat (x, ay);
    case MT_Double:
	return doSub_with_dfloat (x, ay);
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (x, PID_SUB, ay);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (subform (ax, ay,"rev_sub"),CAN_NOT_FIND_METHOD,"sub/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

METHOD (sub, R3_OP)
    // {}
    // sub Ri,Rj,Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj η̤ Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b2] = doSub (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevSub_fixnum (Word y, Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS number
    // {} @ NOTATION Y:rev_sub(X,^Z)
    // {} @ EXPLANATION
    // X  Y , η̤򥹥ȥ꡼Z³롥X  Y 
    // ؿ٤ηۤʤ硤ѴԤʤ
    // X ̤³ʥ祤Ȥξϥ顼Ǥ롥
    // {} @ METHOD END
{
    doSplit (y);
    return doSub_with_fixnum (x, y);
}

Word
doRevSub_sfloat (Word y, Word x)
    // {}
    // ؿ doSub(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡñư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    doSplit (y);
    return doSub_with_sfloat (x, y);
}

Word
doRevSub_dfloat (Word y, Word x)
    // {}
    // ؿ doSub(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    doSplit (y);
    return doSub_with_dfloat (x, y);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
