/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"
#include "mathematics/type.h"

#define ShiftLeft(x,y) (Int2Fix(Fix2Int(x) << Fix2Int(y)))

inline Word
doShtl_with_fixnum (Word ax, Word ay)
    // {}
    //  x 򥪥֥ y ۤɺӥåȥեȤ, η̤֤y
    // ǤʤХ顼ȯ롥y ηޤäƤʤ祤
    // Ȥξ硤뤤ϥ桼֥Ȥξ硤å
    // 롥
    // {}
{
    Word z;
    Word y = ay;
    y = Dereference(ay);
 retry:
    switch(MathType(y)) {
    case MT_Connected:
	y = J_C_ptr(y)->Destination();
	goto retry;
    case MT_Fixnum:
	z = ShiftLeft (ax, y);
	break;
    case MT_User:
    case MT_Joint:
	z =  SendBuiltinMessage2 (y, PID_REV_SHTL_FIXNUM, ax);
	break;
    case MT_Sink:
    default:
	error (form ("%s:shtl(%s,^Z)", print (ax), print (ay)),
	       "%s is not an integer", print (ay));
	return SINKOBJ;
    }
    doClose(ay);
    return z;
}

Word
doShtl (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS integer
    // {} @ NOTATION X:shtl(Y,^Z)
    // {} @ MACRO  X << Y = ^Z
    // {} @ EXPLANATION
    // X  YȤʤСX  Y ӥåȺեȤ, ̤򥹥ȥ꡼
    //  Z ³롥եȱ黻ѥեȤžեȤϥޥ
    // ¸Ǥ롥
    // @send_when_cant_execute{Y}{rev_shtl(X,^Z)}
    // {} @ METHOD END
{
    Word x = ax;
    Word z;
 retry:
    switch(MathType(x)) {
    case MT_Connected:
	x = J_C_ptr(x)->Destination();
	goto retry;
    case MT_Fixnum:
	return doShtl_with_fixnum (x, ay);
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (x, PID_SHTL, ay);
	break;
    default:
	error (form ("%s:shtl(%s,^Z)",print (ax), print (ay)),
	       CAN_NOT_FIND_METHOD,"shtl/+-");
	return SINKOBJ;
    }
    doClose(ay);
    return z;
}

METHOD (shtl, R3_OP)
    // {}
    // shtl Rx,Ry,Rz
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Rx  Ry ӥåȺեȤ, ̤ Rz ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b2] = doShtl (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevShtl_fixnum (Word ay, Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS integer
    // {} @ NOTATION Y:rev_shtl(X,^Z)
    // {} @ EXPLANATION
    // X  YȤʤСX  Y ӥåȺեȤ, ̤򥹥ȥ꡼
    // Z³롥X ̤³ʥ祤Ȥξϥ顼Ǥ롥
    // {} @ METHOD END
{
    doSplit(ay);
    return doShtl_with_fixnum (ax,ay);
}

#define	 ShiftRight(x,y) (Int2Fix(Fix2Int(x) >> Fix2Int(y)))

inline Word
doShtr_with_fixnum (Word ax, Word ay)
    // {}
    //  x 򥪥֥ y ۤɱӥåȥեȤ, η̤֤y
    // ǤʤХ顼ȯ롥y ηޤäƤʤ祤
    // Ȥξ硤뤤ϥ桼֥Ȥξ硤å
    // 롥
    // {}
{
    Word z;
    Word y = ay;
    y = Dereference(ay);
 retry:
    switch(MathType(y)) {
    case MT_Connected:
	y = J_C_ptr(y)->Destination();
	goto retry;
    case MT_Fixnum:
	z = ShiftRight (ax, y);
	break;
    case MT_User:
    case MT_Joint:
	z = SendBuiltinMessage2 (y, PID_REV_SHTR_FIXNUM, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (form ("%s:shtr(%s,^Z)", print (ax), print (ay)),
	       "%s is not an integer", print (ay));
	return SINKOBJ;
    }
    doClose(ay);
    return z;
}

Word
doShtr (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS integer
    // {} @ NOTATION X:shtr(Y,^Z)
    // {} @ MACRO  X >> Y = ^Z
    // {} @ EXPLANATION
    // X  YȤʤСX  Y ӥåȱեȤ, ̤򥹥ȥ꡼
    //  Z ³롥եȱ黻ѥեȤžեȤϥޥ
    // ¸Ǥ롥
    // @send_when_cant_execute{Y}{rev_shtr(X,^Z)}
    // {} @ METHOD END
{
    Word z;
    Word x = ax;
 retry:
    switch(MathType(x)) {
    case MT_Connected:
	x = J_C_ptr(x)->Destination();
	goto retry;
    case MT_Fixnum:
	return doShtr_with_fixnum (x, ay);
    case MT_User:
    case MT_Joint:
	z = SendBuiltinMessage2 (x, PID_SHTR, ay);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (form ("%s:shtr(%s,^Z)",print (x), print (ay)),
	       CAN_NOT_FIND_METHOD,"shtr/+-");
	return SINKOBJ;
    }
    doClose(ay);
    return z;
}


METHOD (shtr, R3_OP)
    // {}
    // shtr Rx,Ry,Rz
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Rx  Ry ӥåȱեȤ, ̤ Rz ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b2] = doShtr (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevShtr_fixnum (Word ay, Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS integer
    // {} @ NOTATION Y:rev_shtr(X,^Z)
    // {} @ EXPLANATION
    // X  YȤʤСX  Y ӥåȱեȤ, 
    // ̤򥹥ȥ꡼Z³롥
    // X ̤³ʥ祤Ȥξϥ顼Ǥ롥
    // {} @ METHOD END
{
    doSplit(ay);
    return doShtr_with_fixnum (ax, ay);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
