/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <math.h>

#include "mathematics/mathematics.h"
#include "mathematics/type.h"
#include "aum/string.h"

Word FixFixPow(Word& x,Word& y)
{
    return CreateDFloat(pow((double)Fix2Int(x),(double)Fix2Int(y)));
}

Word SFloatFixPow(Word& x,Word &y)
{
    return CreateDFloat(pow((double)Single2float(x),(double)Fix2Int(y)));
}

Word DoubleFixPow(Word& x,Word&y)
{
    return CreateDFloat(pow(Double2double(x),(double)Fix2Int(y)));
}

Word FixSFloatPow(Word& x,Word& y)
{
    return CreateDFloat(pow((double)Fix2Int(x),(double)Single2float(y)));
}

Word SFloatSFloatPow(Word& x,Word& y)
{
    return CreateDFloat(pow((double)Single2float(x),(double)Single2float(y)));
}

Word DoubleSFloatPow(Word& x,Word& y)
{
    return CreateDFloat(pow((double)Double2double(x),(double)Single2float(y)));
}

Word FixDoublePow(Word& x,Word& y)
{
    return CreateDFloat(pow((double)Fix2Int(x),Double2double(y)));
}

Word SFloatDoublePow(Word& x,Word& y)
{
    return CreateDFloat(pow((double)Single2float(x),Double2double(y)));
}

Word DoubleDoublePow(Word& x,Word& y)
{
    return CreateDFloat(pow(Double2double(x),Double2double(y)));
}

Word doFixPow(Word ax, Word ay)
// {}
// x
// {}
{
    Word z;
    Word y = ay;
 retry:
    switch(MathType(y)){
    case MT_Connected:
	y = Dereference (y);
	goto retry;

    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2(y,PID_REV_POW_FIXNUM,ax);
	break;
    case MT_Fixnum:
	z = FixFixPow(ax,y);
	break;
    case MT_Single:
	z = FixSFloatPow(ax,y);
	break;
    case MT_Double:
	z = FixDoublePow(ax,y);
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error(form("pow %s %s", print(ax),print(ay)),
	      "Can't coerce %s to NUMERICAL", print(ay));
	return SINKOBJ;
    }
    doClose(ay);
    return z;
}

Word doSFloatPow(Word ax, Word ay)
// {}
// x
// {}
{
    Word z;
    Word y = ay;
 retry:
    switch(MathType(y)){
    case MT_Connected:
	y = Dereference (y);
	goto retry;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2(y,PID_REV_POW_SFLOAT,ax);
	break;
    case MT_Fixnum:
	z = SFloatFixPow(ax,y);
	break;
    case MT_Single:
	z = SFloatSFloatPow(ax,y);
	break;
    case MT_Double:
	z =  SFloatDoublePow(ax,y);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error(form("pow %s %s", print(ax),print(ay)),
	      "Can't coerce %s to NUMERICAL", print(ay));
	return SINKOBJ;
    }
    doClose(ay);
    return z;
}

Word doDoublePow(Word ax, Word ay)
    // {}
    // x
    // {}
{
    Word z;
    Word y = ay;
 retry:
    switch(MathType(y)){
    case MT_Connected:
	y = Dereference (y);
	goto retry;
    case MT_Joint:
    case MT_User:
	z =  SendBuiltinMessage2(y,PID_REV_POW_DFLOAT,ax);
	break;
    case MT_Fixnum:
	z = DoubleFixPow(ax,y);
	break;
    case MT_Single:
	z = DoubleSFloatPow(ax,y);
	break;
    case MT_Double:
	z = DoubleDoublePow(ax,y);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error(form("pow %s %s", print(ax),print(ay)),
	      "Can't coerce %s to NUMERICAL", print(ay));
	return SINKOBJ;
    }
    doClose(ay);
    return z;
}

Word doPow(Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS mathematics
    // {} @ NOTATION X:pow(Y,^Z)
    // {} @ EXPLANATION
    // XY
    // @tex
    // ($X^Y$)
    // @end tex
    // ưȤ򥹥ȥ꡼Z³롥
    // YϿǤʤƤϤʤʤ
    // @send_when_cant_execute{Y}{rev_pow(X,^Z)}
    // {} @ METHOD END
{
    Word z;
    Word x = ax;
 retry:
    switch(MathType(x)) {
    case MT_Connected:
	x = J_C_ptr(x)->Destination();
	goto retry;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2(x,PID_POW,ay);
	break;
    case MT_Fixnum:
	z = doFixPow(x,ay);
	break;
    case MT_Single:
	z = doSFloatPow(x,ay);
	break;
    case MT_Double:
	z = doDoublePow(x,ay);
	break;
    default:
	error(form("pow %s %s", print(x),print(ay)),
	      "Can't coerce %s to NUMERICAL", print(x));
	return SINKOBJ;
    }
    doClose(ay);
    return z;
}

METHOD(pow, R3_OP)
    // {}
    // pow Ri,Rj,Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	 00]
    // {}
    // Ri  Rj  Rk Ȥ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doPow(x,Reg[ip->b1]);
    doClose(x);
    JumpNextInstruction();
}

Word doRevFixPow(Word y, Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS mathematics
    // {} @ NOTATION Y:rev_pow(X,^Z)
    // {} @ EXPLANATION
    // XY
    // @tex
    // ($X^Y$)
    // @end tex
    // ưȤ򥹥ȥ꡼Z³롥
    // X ̤³ʥ祤Ȥξϥ顼Ǥ롥
    // {} @ METHOD END
{
    doSplit(y);
    return doFixPow(x, y);
}

Word doRevSFloatPow(Word y, Word x)
// {}
// x
// {}
{
    doSplit(y);
    return doSFloatPow(x, y);
}

Word doRevDFloatPow(Word y, Word x)
    // {}
    // x
    // {}
{
    doSplit(y);
    return doDoublePow(x, y);
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
