/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef mathematics_mul_h
#define mathematics_mul_h

inline	Word
FixnumMul (Word& x, Word& y)
{
    return Int2Fix (Fix2Int (x) * Fix2Int (y));
}

inline Word
FixSingleMul (Word& x, Word& y)
{
    return float2Single ((float) Fix2Int (x) * Single2float (y));
}

inline Word
SingleFixMul (Word& x, Word& y)
{
    return float2Single (Single2float (x) * (float) Fix2Int (y));
}

inline Word
SingleFloatMul(Word& x, Word& y)
{
    return float2Single (Single2float (x) * Single2float (y));
}

inline Word
DoubleFixMul (Word& x, Word& y)
{
    return CreateDFloat (Double2double (x) * (double) Fix2Int (y));
}

inline Word
FixDoubleMul (Word& x, Word& y)
{
    return CreateDFloat ((double) Fix2Int (x) * Double2double (y));
}

inline Word
DoubleSingleMul (Word& x, Word& y)
{
    return CreateDFloat (Double2double (x) * (double) Single2float (y));
}

inline Word
SingleDoubleMul (Word& x, Word& y)
{
    return CreateDFloat ((double) Single2float (x) * Double2double (y));
}

inline Word
DoubleFloatMul (Word& x, Word& y)
{
    return CreateDFloat (Double2double (x) * Double2double (y));
}

#endif				/* !mathematics_mul_h */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
