/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"
#include "mathematics/type.h"
#include "mathematics/mul.h"

static const char *
mulform (Word x, Word y,const char* name)
{
    return form ("%s :%s(%s,^Z)", print (x),name, print (y));
}

Word
doMul_with_fixnum (Word ax, Word ay)
    // {}
    //  x 饪֥ y 軻, η̤֤x  y 
    // ؿ٤ηۤʤ硤ѴԤʤy ηޤäƤ
    // ʤ祤Ȥξ硤뤤ϥ桼֥Ȥξ硤
    // 롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = FixnumMul (ax, y);
	break;
    case MT_Single:
	z = FixSingleMul (ax, y);
	break;
    case MT_Double:
	z = FixDoubleMul (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_MUL_FIXNUM, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (mulform (ax, ay,"rev_mul"),CAN_NOT_FIND_METHOD,"rev_mul/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doMul_with_sfloat (Word ax, Word ay)
    // {}
    // ñư x 饪֥ y 軻, η̤
    // x  y Ρؿ٤ηۤʤ硤ѴԤʤy 
    // ηޤäƤʤ祤Ȥξ硤뤤ϥ桼֥
    // ξ硤å롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = SingleFixMul (ax, y);
	break;
    case MT_Single:
	z = SingleFloatMul (ax, y);
	break;
    case MT_Double:
	z = SingleDoubleMul (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_MUL_SFLOAT, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (mulform (ax, ay,"rev_mul"),CAN_NOT_FIND_METHOD,"rev_mul/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doMul_with_dfloat (Word ax, Word ay)
    // {}
    // ư x 饪֥ y 軻, η̤
    // x  y Ρؿ٤ηۤʤ硤ѴԤʤy 
    // ηޤäƤʤ祤Ȥξ硤뤤ϥ桼֥
    // ξ硤å롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = DoubleFixMul (ax, y);
	break;
    case MT_Single:
	z = DoubleSingleMul (ax, y);
	break;
    case MT_Double:
	z = DoubleFloatMul (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_MUL_DFLOAT, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (mulform (ax, ay,"rev_mul"),CAN_NOT_FIND_METHOD,"rev_mul/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doMul (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS number
    // {} @ NOTATION X:mul(Y,^Z)
    // {} @ MACRO  X * Y = ^Z
    // {} @ EXPLANATION
    // XY軻η̤򥹥ȥ꡼Z³롥X YΡؿ٤
    // ۤʤ硤ѴԤʤ
    // @send_when_cant_execute{Y}{mul(X,^Z)}
    // {} @ METHOD END
{
    Word    x = ax;
    Word    z;
retry:
    switch (MathType (x)) {
    case MT_Connected:
	x = J_C_ptr (x)->Destination ();
	goto retry;
    case MT_Fixnum:
	return doMul_with_fixnum (x, ay);
    case MT_Single:
	return doMul_with_sfloat (x, ay);
    case MT_Double:
	return doMul_with_dfloat (x, ay);
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (x, PID_MUL, ay);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (mulform (ax, ay,"mul"),CAN_NOT_FIND_METHOD,"mul/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

METHOD (mul, R3_OP)
    // {}
    // mul Ri,Rj,Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj 軻η̤ Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b2] = doMul (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevMul_fixnum (Word y, Word x)
    // {}
    // ؿ doMul(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡ٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    doSplit (y);
    return doMul_with_fixnum (x, y);
}

Word
doRevMul_sfloat (Word y, Word x)
    // {}
    // ؿ doMul(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡñư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    doSplit (y);
    return doMul_with_sfloat (x, y);
}

Word
doRevMul_dfloat (Word y, Word x)
    // {}
    // ؿ doMul(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    doSplit (y);
    return doMul_with_dfloat (x, y);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
