/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"
#include "mathematics/type.h"
#include "mathematics/mod.h"

Word
ZeroMod (Word x, Word y)
{
    error (form ("%s mod %s", print (x), print (y)),
	   "Attempt to divide %s by %s", print (x), print (y));
    return SINKOBJ;
}

static const char *
modform (Word x, Word y,const char* name)
{
    return form ("%s :%s(%s,^Z)", print (x),name, print (y));
}

inline Word
doMod_with_fixnum (Word ax, Word ay)
    // {}
    //  x  y , ;֤y Ǥʤ
    // 顼ȯ롥y ηޤäƤʤ祤Ȥξ硤
    // ϥ桼֥Ȥξ硤å롥
    // {}
{
    Word    y = ay;
    Word    z;
 retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = FixnumMod (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_MOD_FIXNUM, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    case MT_Single:
    case MT_Double:
    default:
	error (modform (ax, ay, "rev_mod"),CAN_NOT_FIND_METHOD,"rev_mod/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doMod (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS integer
    // {} @ NOTATION X:mod(Y,^Z)
    // {} @ EXPLANATION
    // X  Y ʤ X  Y ǽ, ;򥹥ȥ꡼Z
    // ³롥
    // @send_when_cant_execute{Y}{rev_mod(X,^Z)}
    // {} @ METHOD END
{
    Word    x = ax;
    Word    z;
retry:
    switch (MathType (x)) {
    case MT_Connected:
	x = J_C_ptr (x)->Destination ();
	goto retry;
    case MT_Fixnum:
	return doMod_with_fixnum (x, ay);
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (x, PID_MOD, ay);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    case MT_Single:
    case MT_Double:
    default:
	error (modform (ax, ay,"mod"),CAN_NOT_FIND_METHOD,"mod/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

METHOD (mod, R3_OP)
    // {}
    // mod Ri,Rj,Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj ǽ; Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doMod (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevMod_fixnum (Word y, Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS integer
    // {} @ NOTATION Y:rev_mod(X,^Z)
    // {} @ EXPLANATION
    // X  Y ʤ X  Y ǽ, ;򥹥ȥ꡼Z
    // ³롥
    // X ̤³ʥ祤Ȥξϥ顼Ǥ롥
    // {} @ METHOD END
{
    doSplit (y);
    return doMod_with_fixnum (x, y);
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
