/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"
#include "mathematics/type.h"
#include "mathematics/minus.h"

Word
doMinus (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS number
    // {} @ NOTATION X:minus(^Y)
    // {} @ EXPLANATION
    // Xȿž֥Ȥ򥹥ȥ꡼Y³
    // 롥֥Xȥ֥YηƱȤʤ롥
    // {} @ METHOD END
{
    Word    x = ax;
retry:
    switch (MathType (x)) {
    case MT_Connected:
	x = J_C_ptr (x)->Destination ();
	goto retry;
    case MT_Fixnum:
	return Int2Fix (-Fix2Int (x));
    case MT_Single:
	return SingleFloatMinus (x);
    case MT_Double:
	return DoubleFloatMinus (x);
    case MT_Joint:
    case MT_User:
	return SendBuiltinMessage1 (x, PID_MINUS);
    case MT_Sink:
	return SINKOBJ;
    default:
	error (form ("%s :minus(^Y)", print (ax)),
	       CAN_NOT_FIND_METHOD,"minus/-");
	return SINKOBJ;
    }
}

METHOD (minus, R2_OP)
    // {}
    // minus Ri,Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|   0|	  0]
    // {}
    // Ri Ѥ̤ Rj ˥åȤ롥
    // {}
{
    Fetch112 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b1] = doMinus (x);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
