/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef mathematics_mathlib_h
#define mathematics_mathlib_h

#include <math.h>
#include "aum/protocolid.h"
#include "aum/header.h"
#include "aum/word.h"
#include "aum/error.h"
#include "mathematics/ext-conv.h"

class MathLib1 {
private:
    const char *const  name;
    const ProtocolID   pid;
    const Word (*const fixnum)(Word&);
    const Word (*const sfloat)(Word&);
    const Word (*const dfloat)(Word&);

public:
    MathLib1(const char *const n,
	     const ProtocolID	p,
	     const Word (*const f)(Word&),
	     const Word (*const s)(Word&),
	     const Word (*const d)(Word&))
      : name(n), pid(p), fixnum(f), sfloat(s), dfloat(d) {}

    Word	Calculate(Word&) const;
};

extern Word SendBuiltinMessage1(Word, ProtocolID);
extern Name print(Word);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !mathematics_mathlib_h */
