/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/


#include "aum/objecttag.h"
#include "mathematics/mathematics.h"
#include "aum/string.h"

extern	"C" {
    int	    atoi ();
};
extern Name print (Word x);

Word
doInt (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS number string
    // {} @ NOTATION X:int(^Y)
    // {} @ EXPLANATION
    // Xɽ֥Ȥ뤤ʸΤȤXɽͤ
    // 򥹥ȥ꡼Y³롥
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    if (IsFixnum (x))
	return x;
    else if (IsSFloat (x))
	return Int2Fix ((int) Single2float (x));
    else if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case DFLOAT:
	    return Double2Fix (x);

	case ASCII_STR:
	    return ASCII2Fix (ASCII_StrObject_ptr (x));

	case EUC_STR:
	    return EUC2Fix (EUC_StrObject_ptr (x));

	case WC_ASCII_STR:
	    return ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_INT);

	case WC_EUC_STR:
	    return EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_INT);

	case OBJECT:
	    return SendBuiltinMessage1 (x, PID_INT);

	default:
	    break;
	}
    }
    else
	if (IsUndefined (x))
	    return SendBuiltinMessage1 (x, PID_INT);

    error (form ("%s :int(^Y)", print (x)),
	   CAN_NOT_FIND_METHOD,"int/-");
    return SINKOBJ;
}

METHOD (int, R2_OP)
    // {}
    // int Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|  00|	 00]
    // {}
    // Ri Ѵ Rj ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doInt (x);
    doClose (x);
    JumpNextInstruction ();
}
/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
