/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdlib.h>
#include "mathematics/mathlib.h"
#include "aum/builtin.h"
#include "aum/fetch.h"

Word FixHtan(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(tanh((double)ival));
}

Word SFloatHtan(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(tanh((double)sval));
}

Word DoubleHtan(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(tanh(dval));
}

Word FixTan(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(tan((double)ival));
}

Word SFloatTan(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(tan((double)sval));
}

Word DoubleTan(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(tan(dval));
}


Word FixSqrt(Word& x)
{
    int	 ival = Fix2Int(x);
    if (ival <= 0){
	error(form("sqrt (int) %d",ival),
	      form("illegal value %d ",ival));
    }
    return CreateDFloat(sqrt((double)ival));
}

Word SFloatSqrt(Word& x)
{
    float sval = Single2float(x);
    if (sval <= 0){
	error(form("sqrt (float) %f",sval),
	      form("illegal value %f ",sval));
    }
    return CreateDFloat(sqrt((double)sval));
}

Word DoubleSqrt(Word& x)
{
    double dval = Double2double(x);
    if (dval <= 0){
	error(form("sqrt (double) %g",dval),
	      form("illegal value %g ",dval));
    }
    return CreateDFloat(sqrt(dval));
}


Word FixHsin(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(sinh((double)ival));
}

Word SFloatHsin(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(sinh((double)sval));
}

Word DoubleHsin(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(sinh(dval));
}

Word FixSin(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(sin((double)ival));
}

Word SFloatSin(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(sin((double)sval));
}

Word DoubleSin(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(sin(dval));
}


Word FixDlog(Word& x)
{
    int	 ival = Fix2Int(x);
    if (ival <= 0){
	error(form("log10 (int) %d",ival),
	      form("illegal value %d ",ival));
    }
    return CreateDFloat(log10((double)ival));
}

Word SFloatDlog(Word& x)
{
    float sval = Single2float(x);
    if (sval <= 0){
	error(form("log10 (float) %f",sval),
	      form("illegal value %f ",sval));
    }
    return CreateDFloat(log10((double)sval));
}

Word DoubleDlog(Word& x)
{
    double dval = Double2double(x);
    if (dval <= 0){
	error(form("log10 (double) %g",dval),
	      form("illegal value %g ",dval));
    }
    return CreateDFloat(log10(dval));
}


Word FixLog(Word& x)
{
    int	 ival = Fix2Int(x);
    if (ival <= 0){
	error(form("log (int) %d",ival),
	      form("illegal value %d ",ival));
    }
    return CreateDFloat(log((double)ival));
}

Word SFloatLog(Word& x)
{
    float sval = Single2float(x);
    if (sval <= 0){
	error(form("log (float) %f",sval),
	      form("illegal value %f ",sval));
    }
    return CreateDFloat(log((double)sval));
}

Word DoubleLog(Word& x)
{
    double dval = Double2double(x);
    if (dval <= 0){
	error(form("log (double) %g",dval),
	      form("illegal value %g ",dval));
    }
    return CreateDFloat(log(dval));
}

Word FixGamma(Word& x)
{
    int	 ival = Fix2Int(x);
    if (ival <= 0){
	error(form("gamma (int) %d",ival),
	      form("illegal value %d ",ival));
    }
    return CreateDFloat(gamma((double)ival));
}

Word SFloatGamma(Word& x)
{
    float sval = Single2float(x);
    if (sval <= 0){
	error(form("gamma (float) %f",sval),
	      form("illegal value %f ",sval));
    }
    return CreateDFloat(gamma((double)sval));
}

Word DoubleGamma(Word& x)
{
    double dval = Double2double(x);
    if (dval <= 0){
	error(form("gamma (double) %g",dval),
	      form("illegal value %g ",dval));
    }
    return CreateDFloat(gamma(dval));
}


Word FixFloor(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(floor((double)ival));
}

Word SFloatFloor(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(floor((double)sval));
}

Word DoubleFloor(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(floor(dval));
}


Word FixExp(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(exp((double)ival));
}

Word SFloatExp(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(exp((double)sval));
}

Word DoubleExp(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(exp(dval));
}

Word FixFabs(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(fabs((double)ival));
}

Word SFloatFabs(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(fabs((double)sval));
}

Word DoubleFabs(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(fabs(dval));
}

Word FixHcos(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(cosh((double)ival));
}

Word SFloatHcos(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(cosh((double)sval));
}

Word DoubleHcos(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(cosh(dval));
}


Word FixCos(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(cos((double)ival));
}

Word SFloatCos(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(cos((double)sval));
}

Word DoubleCos(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(cos(dval));
}

Word FixCeil(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(ceil((double)ival));
}

Word SFloatCeil(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(ceil((double)sval));
}

Word DoubleCeil(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(ceil(dval));
}

Word FixBfy1(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(y1((double)ival));
}

Word SFloatBfy1(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(y1((double)sval));
}

Word DoubleBfy1(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(y1(dval));
}

Word FixBfy0(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(y0((double)ival));
}

Word SFloatBfy0(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(y0((double)sval));
}

Word DoubleBfy0(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(y0(dval));
}

Word FixBfj1(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(j1((double)ival));
}

Word SFloatBfj1(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(j1((double)sval));
}

Word DoubleBfj1(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(j1(dval));
}

Word FixBfj0(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(j0((double)ival));
}

Word SFloatBfj0(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(j0((double)sval));
}

Word DoubleBfj0(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(j0(dval));
}

Word FixAtan(Word& x)
{
    int	 ival = Fix2Int(x);
    return CreateDFloat(atan((double)ival));
}

Word SFloatAtan(Word& x)
{
    float sval = Single2float(x);
    return CreateDFloat(atan((double)sval));
}

Word DoubleAtan(Word& x)
{
    double dval = Double2double(x);
    return CreateDFloat(atan(dval));
}


Word FixAsin(Word& x)
{
    int	 ival = Fix2Int(x);
    if ((ival <= -1)||(ival >= 1)){
	error(form("asin (int) %d",ival),
	      form("illegal value %d ",ival));
	return INT0;
    }
    return CreateDFloat(asin((double)ival));
}
Word SFloatAsin(Word& x)
{
    float sval = Single2float(x);
    if ((sval <= -1)||(sval >= 1)){
	error(form("asin (float) %f",sval),
	      form("illegal value %f ",sval));
	return INT0;
    }
    return CreateDFloat(asin((double)sval));
}

Word DoubleAsin(Word& x)
{
    double dval = Double2double(x);
    if ((dval <= -1)||(dval >= 1)){
	error(form("asin (double) %g",dval),
	      form("illegal value %g ",dval));
	return INT0;
    }
    return CreateDFloat(asin(dval));
}

Word FixAcos(Word& x)
{
    int	 ival = Fix2Int(x);
    if ((ival <= -1)||(ival >= 1)){
	error(form("acos (int) %d",ival),
	      form("illegal value %d ",ival));
	return INT0;
    }
    return CreateDFloat(acos((double)ival));
}

Word SFloatAcos(Word& x)
{
    float sval = Single2float(x);
    if ((sval <= -1)||(sval >= 1)){
	error(form("acos (float) %f",sval),
	      form("illegal value %f ",sval));
	return INT0;
    }
    return CreateDFloat(acos((double)sval));
}

Word DoubleAcos(Word& x)
{
    double dval = Double2double(x);
    if ((dval <= -1)||(dval >= 1)){
	error(form("acos (double) %g",dval),
	      form("illegal value %g ",dval));
	return INT0;
    }
    return CreateDFloat(acos(dval));
}

Word FixAbs(Word& x)
{
    int	 ival = Fix2Int(x);
    return Int2Fix(abs(ival));
}

Word SFloatAbs(Word& x)
{
    float sval = Single2float(x);
    return Int2Fix(abs((int)sval));
}

Word DoubleAbs(Word& x)
{
    double dval = Double2double(x);
    return Int2Fix(abs((int)dval));
}
/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
