/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"
#include "aum/string.h"

// convert  single floating point data type

Word
doFloat (Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS number string
    // {} @ NOTATION X:float(^Y)
    // {} @ EXPLANATION
    // Xͤɽ֥Ȥ뤤ʸΤȤXɽͤñ
    // ư򥹥ȥ꡼Y³롥
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsFixnum (x))
	return Fix2Single (x);
    else if (IsSFloat (x))
	return x;
    else if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case DFLOAT:
	    return Double2Single (x);

	case ASCII_STR:
	    return ASCII2Single (ASCII_StrObject_ptr (x));

	case EUC_STR:
	    return EUC2Single (EUC_StrObject_ptr (x));

	case WC_ASCII_STR:
	    return ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_FLOAT);

	case WC_EUC_STR:
	    return EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_FLOAT);

	case OBJECT:
	    return SendBuiltinMessage1 (x, PID_FLOAT);

	default:
	    break;
	}
    } else if (IsUndefined (x)) {
	return SendBuiltinMessage1 (x, PID_FLOAT);
    }

    error (form ("%s :float(^Y)", print (x)),
	   CAN_NOT_FIND_METHOD,"float/-");
    return SINKOBJ;
}

METHOD (float, R2_OP)
    // {}
    // float Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // Ri ñưѴ Rj ˥åȤ롥
    // {}
{
    Fetch4 ();
    Reg[ip->b1] = doFloat (Reg[ip->b0]);
    JumpNextInstruction ();
}
/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
