/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"
#include "aum/string.h"

// convert to double floating point data type ;

Word
doDouble (Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS number string
    // {} @ NOTATION X:double(^Y)
    // {} @ EXPLANATION
    // Xͤɽ֥Ȥ뤤ʸΤȤX ɽͤ
    // ưȥ꡼Y³롥
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsFixnum (x))
	return CreateDFloat ((double) Fix2Int (x));
    else if (IsSFloat (x))
	return CreateDFloat ((double) Single2float (x));
    else if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case DFLOAT:
	    doSplit (x);
	    return x;

	case ASCII_STR:
	    return ASCII2Double (ASCII_StrObject_ptr (x));

	case EUC_STR:
	    return EUC2Double (EUC_StrObject_ptr (x));

	case WC_ASCII_STR:
	    return ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_DOUBLE);

	case WC_EUC_STR:
	    return EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_DOUBLE);

	case OBJECT:
	    return SendBuiltinMessage1 (x, PID_DOUBLE);

	default:
	    break;
	}
    }
    else
	if (IsUndefined (x))
	    return SendBuiltinMessage1 (x, PID_DOUBLE);

    error (form ("%s :double(^Y)", print (x)),
	   CAN_NOT_FIND_METHOD,"double/-");
    return SINKOBJ;
}

METHOD (double, R2_OP)
    // {}
    // double Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // Ri ưѴ Rj ˥åȤ롥
    // {}
{
    Fetch4 ();
    Reg[ip->b1] = doDouble (Reg[ip->b0]);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
