/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef mathematics_div_h
#define mathematics_div_h

extern Word ZeroDivide (Word x, Word y);

inline Word
FixnumDiv (Word & x, Word & y)
{
    int	    n = Fix2Int (y);
    if (n == 0)
	return ZeroDivide (x, y);
    return Int2Fix (Fix2Int (x) / n);
}

inline Word
FixSingleDiv (Word& x, Word& y)
{
    float   f = Single2float (y);
    if (f == 0.0)
	return ZeroDivide (x, y);
    return float2Single (((float) Fix2Int (x)) / f);
}

inline Word
SingleFixDiv (Word x, Word y)
{
    float   f = (float) Fix2Int (y);
    if (f == 0.0)
	return ZeroDivide (x, y);
    return float2Single (Single2float (x) / f);
}

inline Word
SingleFloatDiv (Word& x, Word& y)
{
    float   f = Single2float (y);
    if (f == 0.0)
	return ZeroDivide (x, y);
    return float2Single (Single2float (x) / f);
}

inline Word
DoubleFixDiv (Word x, Word y)
{
    double  d = (double) Fix2Int (y);
    if (d == 0.0)
	return ZeroDivide (x, y);
    return CreateDFloat (Double2double (x) / d);
}

inline Word
FixDoubleDiv (Word x, Word y)
{
    double  d = Double2double (y);
    if (d == 0.0)
	return ZeroDivide (x, y);
    return CreateDFloat (((double) Fix2Int (x)) / d);
}

inline Word
DoubleSingleDiv (Word x, Word y)
{
    double  f = (double) Single2float (y);
    if (f == 0.0)
	return ZeroDivide (x, y);
    return CreateDFloat (Double2double (x) / f);
}

inline Word
SingleDoubleDiv (Word x, Word y)
{
    double  d = Double2double (y);
    if (d == 0.0)
	return ZeroDivide (x, y);
    return CreateDFloat (((double) Single2float (x)) / d);
}

inline Word
DoubleFloatDiv (Word x, Word y)
{
    double  d = Double2double (y);
    if (d == 0.0)
	return ZeroDivide (x, y);
    return CreateDFloat (Double2double (x) / d);
}

#endif	/* !mathematics_div_h */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
