/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"
#include "mathematics/type.h"
#include "mathematics/div.h"

Word
ZeroDivide (Word x, Word y)
{
    error (form ("%s / %s", print (x), print (y)),
	   "Attempt to divide %s by %s", print (x), print (y));
    return SINKOBJ;
}

static const char *
divform (Word x, Word y,const char* name)
{
    return form ("%s :%s(%s,^Z)", print (x),name, print (y));
}

Word
doDiv_with_fixnum (Word ax, Word ay)
    // {}
    //  x 饪֥ y , η̤֤x  y 
    // ؿ٤ηۤʤ硤ѴԤʤy ηޤäƤ
    // ʤ祤Ȥξ硤뤤ϥ桼֥Ȥξ硤
    // 롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = FixnumDiv (ax, y);
	break;
    case MT_Single:
	z = FixSingleDiv (ax, y);
	break;
    case MT_Double:
	z = FixDoubleDiv (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_DIV_FIXNUM, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (divform (ax, ay,"rev_div"),CAN_NOT_FIND_METHOD,"rev_div/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doDiv_with_sfloat (Word ax, Word ay)
    // {}
    // ñư x 饪֥ y , η̤
    // x  y Ρؿ٤ηۤʤ硤ѴԤʤy 
    // ηޤäƤʤ祤Ȥξ硤뤤ϥ桼֥
    // ξ硤å롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = SingleFixDiv (ax, y);
	break;
    case MT_Single:
	z = SingleFloatDiv (ax, y);
	break;
    case MT_Double:
	z = SingleDoubleDiv (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_DIV_SFLOAT, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (divform (ax, ay,"rev_div"),CAN_NOT_FIND_METHOD,"rev_div/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doDiv_with_dfloat (Word ax, Word ay)
    // {}
    // ư x 饪֥ y , η̤
    // x  y Ρؿ٤ηۤʤ硤ѴԤʤy 
    // ηޤäƤʤ祤Ȥξ硤뤤ϥ桼֥
    // ξ硤å롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = DoubleFixDiv (ax, y);
	break;
    case MT_Single:
	z = DoubleSingleDiv (ax, y);
	break;
    case MT_Double:
	z = DoubleFloatDiv (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_DIV_DFLOAT, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (divform (ax, ay,"rev_div"),CAN_NOT_FIND_METHOD,"rev_div/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doDiv (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS number
    // {} @ NOTATION X:div(Y,^Z)
    // {} @ MACRO    X / Y = ^Z
    // {} @ EXPLANATION
    // XYǽ, η̤򥹥ȥ꡼Z³롥Y ϿǤʤƤ
    // ʤʤXYΡؿ٤ηۤʤ硤ѴԤʤ
    // @send_when_cant_execute{Y}{rev_div(X,^Z)}
    // {} @ METHOD END
{
    Word    x = ax;
    Word    z;
retry:
    switch (MathType (x)) {
    case MT_Connected:
	x = J_C_ptr (x)->Destination ();
	goto retry;
    case MT_Fixnum:
	return doDiv_with_fixnum (x, ay);
    case MT_Single:
	return doDiv_with_sfloat (x, ay);
    case MT_Double:
	return doDiv_with_dfloat (x, ay);
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (x, PID_DIV, ay);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (divform (ax, ay,"div"),CAN_NOT_FIND_METHOD,"div/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

METHOD (div, R3_OP)
    // {}
    // div Ri,Rj,Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj ǽη̤ Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doDiv (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevDiv_fixnum (Word y, Word x)
    // {}
    // ؿ doDiv(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡ٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    doSplit (y);
    return doDiv_with_fixnum (x, y);
}

Word
doRevDiv_sfloat (Word y, Word x)
    // {}
    // ؿ doDiv(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡñư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    doSplit (y);
    return doDiv_with_sfloat (x, y);
}

Word
doRevDiv_dfloat (Word y, Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS number
    // {} @ NOTATION Y:rev_div(X,^Z)
    // {} @ EXPLANATION
    // XYǽ, η̤򥹥ȥ꡼Z³롥Y ϿǤʤƤ
    // ʤʤXYΡؿ٤ηۤʤ硤ѴԤʤ
    // X ̤³ʥ祤Ȥξϥ顼Ǥ롥
    // {} @ METHOD END
{
    doSplit (y);
    return doDiv_with_dfloat (x, y);
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
