/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"
#include "aum/tstream.h"


// Υեˤϡư˴ؤ桼ƥƥ򽸤Ƥ롥


void DFloatObject::Initialize(double value)
    // {}
    // ư֥Ȥ롥
    // {}
{
    Header::Initialize(DFLOAT, 1);
    real = value;
    return;
}

void DFloatObject::Free()
    // {}
    // ư֥Ȥΰ롣
    // {}
{
    SHARED_FREE(this, sizeof(DFloatObject));
    return;
}

Name DFloatObject::Print()
    // {}
    // ư֥Ȥΰ᡼ʸȤ֤
    // {}
{
    char tem[BUFSIZ];
    tstream tout = tstream(BUFSIZ, tem);
    if (ShowRC) {
	u_short rc = LRC();
	tout.form("%d ", rc);
    }
    tout.form("%g", real);
    return tout.Result();
}

Word CopyDFloat(Word mold)
    // {}
    // ư֥Ȥʣ̤롥
    // {}
{
    DFloatObject* dx = (DFloatObject*)Object_ptr(mold);
    DFloatObject* dy = (DFloatObject*)SHARED_ALLOC(sizeof(DFloatObject));
    dy->Initialize(dx->real);
    return ObjectWord(dy);
}

Word CreateDFloat(double value)
    // {}
    // ư֥Ȥ롥
    // {}
{
    DFloatObject* dx = (DFloatObject*)SHARED_ALLOC(sizeof(DFloatObject));
    dx->Initialize(value);
    return ObjectWord(dx);
}

void DeleteDFloat(Word x)
    // {}
    // ư֥Ȥ롥
    // {}
{
    DFloatObject* dp = (DFloatObject*)Object_ptr(x);
    dp->Free();
    return;
}

void PrintDFloat(Word x)
    // {}
    // ư֥ȤϤ롣
    // {}
{
    DFloatObject* dx = (DFloatObject*)Object_ptr(x);
    cout << dx->Print();
    return;
}

int CompareDFloat(Word x, Word y)
    // {}
    // ư֥ȤӤ򤹤롥
    // {}
{
    DFloatObject* dx = (DFloatObject*)Object_ptr(x);
    DFloatObject* dy = (DFloatObject*)Object_ptr(y);
    if (dx->real > dy->real) return 1;
    if (dx->real < dy->real) return (-1);
    return 0;
}

Name DFloatPrintImage(Word x)
    // {}
    // ư֥ȤΰɽʸȤ֤
    // {}
{
    DFloatObject* dx = (DFloatObject*)Object_ptr(x);
    return dx->Print();
}



/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
