/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"

// Ѵ
float Single2float(Word s)	// AUm_SingleFloat -> C++_float
{
    union {
	float f;
	int  i;
    } conv;
    conv.i = _sfloat_val_(s);
    return conv.f;
}

Word float2Single(float f)	// C++_float -> AUm_SingleFloat
{
    return _make_sfloat_(f);
}

double Double2double(Word x)	// AUm_DoubleFloat -> C++_double
{
    return DFloatObject_ptr(x)->GetValue();
}

Word Fix2Single(Word i)		// AUm_Fixnum -> AUm_SingleFloat
{
    int n = Fix2Int (i);
    float f = (float) n;
    return _make_sfloat_ (f);
}

Word Single2Fix(Word s)		// AUm_SingleFloat -> AUm_Fixnum
{
    float f = Single2float (s);
    int n = (int) f;
    return Int2Fix(n);
}

Word Fix2Double(Word x)		// AUm_Fixnum -> AUm_DoubleFloat
{
    return CreateDFloat(Fix2Int(x));
}

Word Single2Double(Word x)	// AUm_SingleFloat -> AUm_DoubleFloat
{
    float f = Single2float (x);
    double d = (double)f;
    return CreateDFloat(d);
}

Word Double2Fix(Word x)		// AUm_DoubleFloat -> AUm_Fixnum
{
    double d = DFloatObject_ptr (x)->GetValue ();
    return Int2Fix((int)d);
}

Word Double2Single(Word x)	// AUm_DoubleFloat -> AUm_SingleFloat
{
    DFloatObject* dx = (DFloatObject*)Object_ptr(x);
    float f = (float)dx->real;
    return _make_sfloat_(f);
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
