/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "mathematics/mathematics.h"
#include "mathematics/type.h"
#include "mathematics/add.h"

static const char *
addform (Word x, Word y, const char *name)
{
    return form ("%s :%s(%s,^Z)", print (x),name, print (y));
}

Word
doAdd_with_fixnum (Word ax, Word ay)
    // {}
    //  x 饪֥ y û, η̤֤x  y 
    // ؿ٤ηۤʤ硤ѴԤʤy ηޤäƤ
    // ʤ祤Ȥξ硤뤤ϥ桼֥Ȥξ硤
    // 롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = FixnumAdd (ax, y);
	break;
    case MT_Single:
	z = FixSingleAdd (ax, y);
	break;
    case MT_Double:
	z = FixDoubleAdd (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_ADD_FIXNUM, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (addform (ax, ay,"rev_add"),CAN_NOT_FIND_METHOD,"rev_add/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doAdd_with_sfloat (Word ax, Word ay)
    // {}
    // ñư x 饪֥ y û, η̤
    // x  y Ρؿ٤ηۤʤ硤ѴԤʤy 
    // ηޤäƤʤ祤Ȥξ硤뤤ϥ桼֥
    // ξ硤å롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = SingleFixAdd (ax, y);
	break;
    case MT_Single:
	z = SingleFloatAdd (ax, y);
	break;
    case MT_Double:
	z = SingleDoubleAdd (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_ADD_SFLOAT, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (addform (ax, ay,"rev_add"),CAN_NOT_FIND_METHOD,"rev_add/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doAdd_with_dfloat (Word ax, Word ay)
    // {}
    // ư x 饪֥ y û, η̤
    // x  y Ρؿ٤ηۤʤ硤ѴԤʤy 
    // ηޤäƤʤ祤Ȥξ硤뤤ϥ桼֥
    // ξ硤å롥
    // {}
{
    Word    y = ay;
    Word    z;
retry:
    switch (MathType (y)) {
    case MT_Connected:
	y = J_C_ptr (y)->Destination ();
	goto retry;
    case MT_Fixnum:
	z = DoubleFixAdd (ax, y);
	break;
    case MT_Single:
	z = DoubleSingleAdd (ax, y);
	break;
    case MT_Double:
	z = DoubleFloatAdd (ax, y);
	break;
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (y, PID_REV_ADD_DFLOAT, ax);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (addform (ax, ay,"rev_add"),CAN_NOT_FIND_METHOD,"rev_add/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

Word
doAdd (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS number
    // {} @ NOTATION   X:add(Y,^Z)
    // {} @ MACRO      X + Y = ^Z
    // {} @ EXPLANATION
    // XYûη̤򥹥ȥ꡼Z³롥XYΡؿ٤η
    // ۤʤ硤ѴԤʤ
    // @send_when_cant_execute{Y}{add(X,^Z)}
    // {} @ METHOD END
{
    Word    x = ax;
    Word    z;
retry:
    switch (MathType (x)) {
    case MT_Connected:
	x = J_C_ptr (x)->Destination ();
	goto retry;
    case MT_Fixnum:
	return doAdd_with_fixnum (x, ay);
    case MT_Single:
	return doAdd_with_sfloat (x, ay);
    case MT_Double:
	return doAdd_with_dfloat (x, ay);
    case MT_Joint:
    case MT_User:
	z = SendBuiltinMessage2 (x, PID_ADD, ay);
	break;
    case MT_Sink:
	z = SINKOBJ;
	break;
    default:
	error (addform (ax, ay,"add"),CAN_NOT_FIND_METHOD,"add/+-");
	return SINKOBJ;
    }
    doClose (ay);
    return z;
}

METHOD (add, R3_OP)
    // {}
    // add Ri,Rj,Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj ûη̤ Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b2] = doAdd (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevAdd_fixnum (Word y, Word x)
    // {}
    // ؿ doAdd(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡ٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    doSplit (y);
    return doAdd_with_fixnum (x, y);
}

Word
doRevAdd_sfloat (Word y, Word x)
    // {}
    // ؿ doAdd(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡñư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    doSplit (y);
    return doAdd_with_sfloat (x, y);
}

Word
doRevAdd_dfloat (Word y, Word x)
    // {}
    // ؿ doAdd(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    doSplit (y);
    return doAdd_with_dfloat (x, y);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
