/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// ɽ

#ifndef table_h
#define table_h 1

#include "rgline.h"
#include "parse.h"
#include "reg.h"
#include "funadd.gh"

// ̿ᵭɽ
struct pi_table {
    const char* name;		// ̿̾
    const short id;		// ȡֹ
};

typedef struct pi_table PiTable;

static const PiTable Pit[] = {
    ".class",			CLASS,
    ".classref",		CLASSREF,
    ".end",			END,
    ".entry",			ENTRY,
    ".inlet",			INLET,
    ".method",			METHOD,
    ".outlet",			OUTLET,
    ".pid",			PID,
    ".super",			SUPER,
    ".volatile",		VOLATILE,
    ".close_method",		CLOSE_METHOD,
    ".default_method",		DEFAULT_METHOD,
    ".foreign_definition",	FOREIGN_DEFINITION,
    ".name",			FOREIGN_NAME,
    ".arg",			FOREIGN_ARG,
    ".return",			FOREIGN_RETURN,
    ".end_foreign",		FOREIGN_END,
};

#define PITSIZE ((sizeof Pit) / (sizeof(PiTable)))	/* table size */

// 쥸ɽ
struct reg_table {
    const char* name;	// 쥸̾
    const short id;	// 쥸ֹ
};

typedef struct reg_table RegTable;

static const RegTable Ret[] = {
    "Ghost", 0
};

#define REGTSIZE ((sizeof Ret) / (sizeof(RegTable)))	/* table size */

// ѥ쥸ɽ
static const char *const GRet[] = {
     "R0",  "R1",  "R2",  "R3",	 "R4",	"R5",  "R6",  "R7",  "R8",  "R9",
    "R10", "R11", "R12", "R13", "R14", "R15", "R16", "R17", "R18", "R19",
    "R20", "R21", "R22", "R23", "R24", "R25", "R26", "R27", "R28", "R29",
    "R30", "R31", "R32", "R33", "R34", "R35", "R36", "R37", "R38", "R39",
    "R40", "R41", "R42", "R43", "R44", "R45", "R46", "R47", "R48", "R49",
    "R50", "R51", "R52", "R53", "R54", "R55", "R56", "R57", "R58", "R59",
    "R60", "R61", "R62", "R63",
};

#include "inst-table.gh"

#endif

/*-----------------
 * Local Variables:
 * c-argdecl-indent:4
 * c-indent-level:4
 * c-label-offset:-2
 * c-continued-statement-offset:4
 * End:
 */
