/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// ɽؿ

#include <assert.h>
#include <ctype.h>
#include "table.h"
#include "lyerror.h"

extern int str_to_int(char* s, int sign, int radix);

extern "C" {
    int strcmp(const char* s1, const char* s2);
}

int pseudo_instruction(char* pseudo)
    //	pseudo: ʸ
    //
    // ʸ󤬵̿ɽϡΥȡֹ֤
{
    for (int i = 0; i < PITSIZE; i++)
	if (strcmp(Pit[i].name, pseudo) == 0) return Pit[i].id;
    return E_UNDF;
}

int genreg_to_int(char* regs)
    //	regs:	ʸ
    //
    // ʸѥ쥸ɽϡΥ쥸ֹ֤
{
    if (regs[0] == 'R') {
	if (regs[2] == '\0') {
	    if (isdigit (regs[1]))
		return regs[1] - '0';
	}
	int number = str_to_int(regs+1, 1, 10);
	if (number >= 0 && number <= MAXREGS) return number;
    }
    return E_UNDF;
}

int reg_to_int(char* regs)
    //	regs:	ʸ
    //
    // ʸü쥸ɽϡΥ쥸ֹ֤
{
    for (int i = 0; i < REGTSIZE; i++)
	if (strcmp(Ret[i].name, regs) == 0) return Ret[i].id;
    return E_UNDF;
}

const char* preg(int rn)
    //	rn:	쥸ֹ
    //
    // ѥ쥸νϥ᡼롣
{
    if (rn >= 0 && rn <= MAXREGS) return GRet[rn];
    for (int i = 0; i < REGTSIZE; i++)
	if (Ret[i].id == rn) return Ret[i].name;
    return "ERROR";
}

int instruction(const char* insts, int* type)
    //	insts:	ʸ
    //	    type:	ڥɡ
    //
    // ʸ̿ɽϡֹ֤̿ޤڥɡ
    // פ type ֤
{
    int low = 0;
    int high = INSTSIZE - 1;
    int mid, res;
    while (high >= low) {		// ʬõ
	mid = (high + low) / 2;
	const char* name = Inst[mid].name;
	if (name[0] == insts[0]) {
	    if ((res = strcmp(name, insts)) == 0) {
		*type = Inst[mid].type;
		return mid;
	    }
	}
	else {
	    res = name[0] - insts[0];
	}
	if (res > 0) high = mid - 1;
	else low = mid + 1;
    }
    *type = 0;
    return E_UNDF;
}

int instruction_address(int index)
    //	index:	ֹ̿
    //
    // ֹ̿б̿δؿɥ쥹֤
{
    assert (0 <= index && index < INSTSIZE);
    return (int)Inst[index].address;
}

int instruction_type(int index)
    //	index:	ֹ̿
    //
    // ֹ̿б̿Υڥɡפ֤
{
    assert (0 <= index && index < INSTSIZE);
    return Inst[index].type;
}

const char*
find_instruction_name(int address, int* type)
    //	address:  ؿΥɥ쥹
    //	type:	ڥɡ
    //
    // ؿΥɥ쥹̿̾ȥڥɡפ롣
{
    for (int i = 0; i < INSTSIZE; i++) {
	if ((int)Inst[i].address == address) {
	    *type = Inst[i].type;
	    return Inst[i].name;
	}
    }
    return 0;
}
//{}
// ʬδؿϡ̿ǧ줿
// ʸ̿ѴݤΥɤΥեꥯȤ
// ΤǤ롣
// Ϥˤꤢ̿ʸǤ롣ǧ줿
// ¾PEФ̿Ǥ뤫ݤϡʸϤʳǷꤵ
// 뤿ᡢˤ̿ᥳɤɬפȤʤ롣
// ǰʲΣĤδؿѰդơԤ
//{}

int  address_to_index(int add)
    // ̿δؿɥ쥹饤ǥå롣
{

    for (int i = 0; i < INSTSIZE; i++) {
	if ((int)Inst[i].address == add) {
	    return i;
	}
    }
    return -1;
}

/*-----------------
* Local Variables:
* c-argdecl-indent:4
* c-indent-level:4
* c-label-offset:-4
* c-continued-statement-offset:4
* End:
*/
