/*- -*- Mode: C++ -*-							   -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

/* parser program */

%{
#include "config.h"
#include "loader/info.h"
#include "loader/field.h"
#include "loader/lyerror.h"
#include "loader/rgline.h"
#include "loader/mem.h"
#include "utils/utils.h"

static int status0, status1, i;
static int isv = 0;	/* isv = volatile ? 1 : 0; */
static RGBOX rg;
%}

%union{
    const char *name;
    int	 number;
    float fval;
    double dval;
    RGBOX rval;
}

%token CLASS END SUPER INLET OUTLET CLASSREF PID METHOD VOLATILE
%token CLOSE_METHOD DEFAULT_METHOD
%token FOREIGN_DEFINITION FOREIGN_END
%token FOREIGN_NAME FOREIGN_ARG FOREIGN_RETURN
%token ENTRY
%token BTRUE BFALSE
%token <name>LABEL STRINGP CLASS_NAME
%token <number>DEC OCT HEX PML
%token <number>REGS PE_NO
%token <number>NO_OP
%token <number>R1_OP R2_OP R3_OP R31_OP R4_OP R32V1_OP
%token <number>R1X1_OP R2X1_OP R1L2_OP R2L2_OP R1Xe_OP
%token <number>R1D1_OP R1Da_OP R1Db_OP R1Dc_OP R1Do_OP R2D1_OP
%token <number>R1Vi_OP RoVp_OP RnVp_OP RnAf_OP RrVp_OP
%token <number>L1_OP
%token <fval>FLOAT
%token <dval>DOUBLE

%type  <number>number regunit modes pid_data
%type  <rval>regline

%nonassoc ';'
%left ','
%left '!'

%start program

%%
program:  /* empty */
	| program class_unit
	| error ';'
	    {
		parse_error(EP_SYNE, line);
		yyerrok;
		yyclearin;
		return 1;
	    }
	;
class_unit:
	  pseudo_instrs class_expression
	;
class_expression:
	  class_definition
	| volatile_definition
	;
pseudo_instrs:
	  /* empty */
	| pseudo_instrs pseudo_instruction
	;
pseudo_instruction:
	  pid_definition
	;
class_definition:
	  class_beginer data_defs method_defs class_ender
	;
volatile_definition:
	  volatile_beginer data_defs method_defs volatile_ender
	;
class_beginer:
	  CLASS CLASS_NAME ';'
	    {
		cc_name = $2;
		initialize_info();
		status0 = add_refer_info ($2, $2);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	;
volatile_beginer:
	  VOLATILE CLASS_NAME ';'
	    {
		cc_name = $2;
		isv = 1;	/* volatile flag ON */
		initialize_info();
		initialize_volatile_slot();
		status0 = add_refer_info($2, $2);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	;
class_ender:
	  END CLASS_NAME ';'
	    {
		if (strcmp($2, cc_name) != 0) parse_error(EP_CDFE, line);
		else {
		    load_class();
		}
		memoryunsave ($2);
		finalize_info();
	    }
	;
volatile_ender:
	  END CLASS_NAME ';'
	    {
		isv = 0;	/* volatile flag OFF */
		if (strcmp($2, cc_name) != 0) parse_error(EP_CDFE, line);
		else
		    load_class();
		memoryunsave ($2);
		finalize_info();
	    }
	;
pid_definition:
	  PID LABEL ',' STRINGP ',' number ',' modes ';'
	    {
		status0 = add_pid_info($2, $4, $6, $8);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	| PID LABEL ',' pid_data ';'
	    {
		status0 = add_pid_info_primitive($2, $4);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	;
pid_data:
	  number
	    {	$$ = make_aum_integer($1); }
	| FLOAT
	    {	$$ = make_aum_float($1); }
	| LABEL
	    {
		status0 = add_atom_info($1);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
		$$ = status0;
	    }
	| BTRUE
	    {	$$ = make_aum_boolean(BT_TRUE); }
	| BFALSE
	    {	$$ = make_aum_boolean(BT_FALSE); }
	;
data_defs:
	  /* empty */
	| data_defs data_definition
	;
data_definition:
	  super_class_definition
	| refer_class_definition
	| inlet_slot_definition
	| outlet_slot_definition
	| pid_definition
	| foreign_definition
	| foreign_name
	| foreign_arg
	| foreign_return
	| foreign_end
	;
super_class_definition:
	  SUPER CLASS_NAME ';'
	    {
		status0 = add_super_info($2);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	;
refer_class_definition:
	  CLASSREF CLASS_NAME ';'
	    {
		status0 = add_refer_info($2, $2);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	;
inlet_slot_definition:
	  INLET LABEL ';'
	    {
		status0 = add_slot_info($2, ST_INLET);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
		if (status0 == E_SERR) parse_error(EP_ISDF, line);
	    }
	;
outlet_slot_definition:
	  OUTLET LABEL ';'
	    {
		status0 = add_slot_info($2, ST_OUTLET);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	;
foreign_definition:
	  FOREIGN_DEFINITION STRINGP ',' LABEL ';'
	    {
		foreign_definition ($2, $4);
		memoryunsave ($2);
		memoryunsave ($4);
	    }
	;
foreign_name:
	  FOREIGN_NAME STRINGP ';'
	    {
		foreign_name ($2);
		memoryunsave ($2);
	    }
	;
foreign_arg:
	  FOREIGN_ARG LABEL ';'
	    {
		foreign_arg ($2);
		memoryunsave ($2);
	    }
	;
foreign_return:
	  FOREIGN_RETURN LABEL ';'
	    {
		foreign_return ($2);
		memoryunsave ($2);
	    }
	;
foreign_end:
	  FOREIGN_END ';'
	    {
		foreign_end ();
	    }
	;
method_defs:
	  /* empty */
	| method_defs method_definition
	;
method_definition:
	  method_beginer statements
	;
method_beginer:
	  METHOD LABEL ',' STRINGP ',' number ',' modes ';'
	    {
		status0 = add_method_info($2, $4, $6, $8, cof);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	| METHOD LABEL ',' pid_data ';'
	    {
		status0 = add_method_info_primitive($2, $4, cof);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	| METHOD LABEL ';'
	    {
		status0 = add_method_info_primitive($2, 0, cof);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	| CLOSE_METHOD ';'
	    {
		status0 = add_method_info_system(":", cof);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	| DEFAULT_METHOD ';'
	    {
		status0 = add_method_info_system("DEFAULT", cof);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    }
	;
statements:
	  /* empty */
	| statements statement
	    {
		if (cof+MAXIOSZ > ASCODSZ) {
		    parse_error(EP_TBOF, line);
		    return 1;
		}
	    }
	;
statement:
	  address_definition instruction
	| data_entry
	;
address_definition:
	  /* empty */
	| address_definition LABEL ':'
	    {
		status0 = add_label_info ($2, cof);
		if (status0 == E_TOF) parse_error (EP_ITOF, line);
	    }
	;
instruction:
	  single_word
	| double_word
	| triple_word
	| multiple_word
	;
single_word:
	  s_type1
	;
double_word:
	  d_type1 | d_type2 | d_type3 | d_type4
	;
triple_word:
	  t_type1 | t_type2 | t_type3 | t_type4 | t_type5
	;
multiple_word:
	  m_type1 | m_type2 | m_type3
	;
s_type1:
	  NO_OP ';'
	    {	tc[cof++] = $1; }
	;
d_type1:
	  R1_OP REGS ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE4($2, 0, 0, 0);
	    }
	| R2_OP REGS ',' REGS ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE4($2, $4, 0, 0);
	    }
	| R3_OP REGS ',' REGS ',' REGS ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE4($2,$4,$6,0);
	    }
	| R4_OP REGS ',' REGS ',' REGS ',' REGS ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE4($2, $4, $6, $8);
	    }
	;
d_type2:
	 R1X1_OP REGS ',' number ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, 0, $4 & MK_16);
	    }
	| R1X1_OP REGS ',' LABEL ';'
	    {
		status0 = look_slot_info($4);
		if (status0 == E_UNDF) parse_error(EP_NOSC, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, 0, status0);
	    }
	| R1Xe_OP REGS ',' number ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, 0, $4 & MK_16);
	    }
	| R2X1_OP REGS ',' number ',' REGS ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, $6, $4 & MK_16);
	    }
	;
d_type3:
	  R1D1_OP REGS ',' CLASS_NAME ';'
	    {
		status0 = look_refer_info($4);
		memoryunsave ($4);
		if (status0 == E_UNDF) parse_error(EP_NOSC, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, 0, status0);
	    }
	| R2D1_OP REGS ',' REGS ',' CLASS_NAME ';'
	    {
		status0 = look_refer_info($6);
		memoryunsave ($6);
		if (status0 == E_UNDF) parse_error(EP_NOSC, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, $4, status0);
	    }
	| R1Do_OP REGS ',' DOUBLE ';'
	    {
		status0 = add_dfloat_info($4);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, 0, status0);
	    }
	;
d_type4:
	  L1_OP LABEL ';'
	    {
		status0 = add_label_info($2, UNDEF);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
		tc[cof++] = $1;
		tc[cof++] = status0;
	    }
	;
t_type1:
	  R1L2_OP REGS ',' LABEL ',' LABEL ';'
	    {
		status0 = add_label_info($4, UNDEF);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
		status1 = add_label_info($6, UNDEF);
		if (status1 == E_TOF) parse_system_error(EP_ITOF, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, 0, status0);
		tc[cof++] = SF_BYTEXX(status1, 0);
	    }
	| R2L2_OP REGS ',' REGS ',' LABEL ',' LABEL ';'
	    {
		status0 = add_label_info($6, UNDEF);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
		status1 = add_label_info($8, UNDEF);
		if (status1 == E_TOF) parse_system_error(EP_ITOF, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, $4, status0);
		tc[cof++] = SF_BYTEXX(status1, 0);
	    }
	;
t_type2:
	  R1Da_OP REGS ',' CLASS_NAME ',' LABEL ';'
	    {
		status0 = look_refer_info($4);
		if (status0 == E_UNDF) parse_error(EP_NOSC, line);
		status1 = add_atom_info($6);
		if (status1 == E_TOF) parse_system_error(EP_ITOF, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, 0, status0);
		tc[cof++] = status1;
	    }
	;
t_type3:
	  R1Db_OP REGS ',' CLASS_NAME '!' number ';'
	    {
		status0 = look_refer_info($4);
		if (status0 == E_UNDF) parse_error(EP_NOSC, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, 0, status0);
		tc[cof++] = SF_BYTEXX($6 & MK_16, 0);
	    }
	| R1Db_OP REGS ',' CLASS_NAME '!' LABEL ';'
	    {
		status0 = look_refer_info($4);
		if (status0 == E_UNDF) parse_error(EP_NOSC, line);
		status1 = look_slot_info($6);
		if (status1 == E_UNDF) parse_error(EP_NOSC, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, 0, status0);
		tc[cof++] = SF_BYTEXX(status1, 0);
	    };
t_type4:
	R1Dc_OP REGS ',' STRINGP ';'
	  {
	    status0 = add_string_info((char*)jis_to_euc((u_char*)$4));
	    if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
	    tc[cof++] = $1;
	    tc[cof++] = SF_BYTE2X($2, 0,status0);
	  };
t_type5:
	  R1Vi_OP REGS ',' LABEL ';'
	    {
		status0 = add_atom_info($4);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE4($2, 0, 0, 0);
		tc[cof++] = status0;
	    }
	| R1Vi_OP REGS ',' BTRUE ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE4($2, 0, 0, 0);
		tc[cof++] = make_aum_boolean(BT_TRUE);
	    }
	| R1Vi_OP REGS ',' BFALSE ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE4($2, 0, 0, 0);
		tc[cof++] = make_aum_boolean(BT_FALSE);
	    }
	| R1Vi_OP REGS ',' number ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE4($2, 0, 0, 0);
		tc[cof++] = make_aum_integer($4);
	    }
	| R1Vi_OP REGS ',' FLOAT ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE4($2, 0, 0, 0);
		tc[cof++] = make_aum_float($4);
	    };
m_type1:
	  RoVp_OP REGS ',' LABEL regline ';'
	    {
		status0 = look_pid_info($4);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE2X($2, 0, rg.size & MK_16);
		tc[cof++] = status0;
		for (i = 0; i < rg.size; i += 4)
		    tc[cof++] = get_rgline(rg, i);
		rg.size = 0;
	    }
	  |RrVp_OP REGS ',' REGS  regline ';'
	    {
		tc[cof++] = $1;
		tc[cof++] = SF_BYTE4($2, 0,0, rg.size & MK_08);
		for (i = 0; i < rg.size; i += 4)
		    tc[cof++] = get_rgline(rg, i);
		rg.size = 0;
	    }
	;
m_type2:
	  RnVp_OP LABEL regline ';'
	    {
		status0 = look_pid_info($2);
		if (status0 == E_TOF) parse_system_error(EP_ITOF, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTEXX(0, rg.size & MK_16);
		tc[cof++] = status0;
		for (i = 0; i < rg.size; i += 4)
		    tc[cof++] = get_rgline(rg, i);
		rg.size = 0;
	    }
	;
m_type3:
	  RnAf_OP LABEL regline ';'
	    {
		status0 = look_foreign_info ($2);
		if (status0 == E_UNDF) parse_error(EP_NOSF, line);
		tc[cof++] = $1;
		tc[cof++] = SF_BYTEXX (status0, rg.size & MK_16);
		for (i = 0; i < rg.size; i += 4)
		    tc[cof++] = get_rgline (rg, i);
		rg.size = 0;
	    }
	;
data_entry:
	  ENTRY pid_data ',' LABEL ';'
	    {
		status0 = add_label_info($4, UNDEF);
		if (status1 == E_TOF) parse_system_error(EP_ITOF, line);
		tc[cof++] = $2;
		tc[cof++] = status0;
	    }
	;
regline:  /* empty */
	    {	$$ = rg; }
	| regline regunit
	    {
		rg.r[rg.size++] = $2;
		$$ = rg;
	    }
	;
regunit:
	  ',' REGS
	    {	$$ = $2; }
	;
number:
	  DEC | OCT | HEX
	;
modes:
	  DEC | OCT | HEX | PML
	;
%%

int get_rgline(RGBOX rg, int i)
{
    static char b[4];

    int x = rg.size - i;
    for (int n = 0; n < x && n < 4; n++)
	b[n] = rg.r[i++];
    while (n < 4)
	b[n++] = 0;
#ifdef BIG_ENDIAN
    return SF_BYTE4(b[0], b[1], b[2], b[3]);
#else
    return SF_BYTE4(b[3], b[2], b[1], b[0]);
#endif
}

/*-----------------
 * Local Variables:
 * c-argdecl-indent:4
 * c-indent-level:4
 * c-label-offset:-2
 * c-continued-statement-offset:4
 * End:
 */
