/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// 
#include <ctype.h>
#include "aum/string.h"
#include "class/template.h"
#include "class/clink.h"
#include "mathematics/ext-conv.h"
#include "rgline.h"
#include "parse.h"
#include "info.h"
#include "field.h"
#include "lyerror.h"
#include "loader/mem.h"

extern Word InternAtom(Name name);
extern Word CreateDFloat(double value);
extern int instruction_address(int index);
extern int instruction_type(int index);
extern void load_error(int id, char* msg);

// ܥ֥Ȥؿ

int make_aum_boolean(int type)
    //	type:	True or False
    //
    // ֡롦֥Ȥ롣
{
#ifdef UNION_TYPE
    Word x;
    if (type == BT_TRUE) x = BoolWord(0);
    else x = BoolWord(1);
    return x.ival;
#else  UNION_TYPE
    if (type == BT_TRUE) return int(BoolWord(0));
    return int(BoolWord(1));
#endif UNION_TYPE
}

int make_aum_integer(int value)
    //	value:	
    //
    // 롣
{
#ifdef UNION_TYPE
    Word x = Int2Fix(value);
    return x.ival;
#else  UNION_TYPE
    return int(Int2Fix(value));
#endif UNION_TYPE
}

int make_aum_float(float value)
    //	value:	ñư
    //
    // ñư롣
{
    return float2Single (value);
}

// ȹ֥Ȥؿ

static int make_string(struct string_info* si)
    //	si:	ȥ󥰤뤿ɬפʥǡ
    //	create_string -> ASCII , EUC String Class롣
    //
    // ȥ󥰡֥Ȥ롣
{
    Word xs;
    // if si->elements is composed only ascii character then
    // ascii string object generate
    // else
    //jis string object do
    if( si->nchars == si->nbytes )
	{
	    xs = CreateASCIIString(si->elements);
	}
    else
	{
	    xs = CreateEUCString((u_char*)si->elements);
	}
    return (int)xs;
}

static int make_dfloat(double dp)
    //	dp:	ư
    //
    // ư֥Ȥ롣
{
    Word dx = CreateDFloat(dp);
    return (int)dx;
}

// ɡ⥸塼Υ٥ꤹؿ

static int fix_label(int index, int real, int dsz)
    //	index:	label_info_table Υեå
    //	real:	ߤΥɡ⥸塼⥪եå
    //	dsz:	ǡΰΥ
    //
    // ΰΥ٥Ϥꤹ롣
{
    int offset = label_info_table[index].offset;
    return offset - real;
}


static int fix_refer_label(int index, int real, int osz)
    //	index:	ǡΰΥ饹ƥץ졼ȤǼΰ
    //		    Υեå
    //	real:	ߤΥɡ⥸塼⥪եå
    //	osz:	ǡΰΥ֥ȤǼΰΥ
    //		 + ΰΥ
    //
    // ǡΰΥ饹ƥץ졼ȤǼΰؤΥ٥
    // Ϥꤹ롣
{
    return (osz - real) + index;
}

static int fix_obj_label(int index, int real, int csz)
    //	index:	ǡΰΥ֥ȤǼΰΥ
    //		    å
    //	real:	ߤΥɡ⥸塼⥪եå
    //	csz:	ΰΥ
    //
    // ǡΰΥ֥ȤǼΰؤΥ٥
    // ꤹ롣
{
    return (csz - real) + index;
}

int fix_atom_id(Name name)
    //	name:	ȥ̾
    //
    // ȥֹꤹ롣
{
#ifdef UNION_TYPE
    Word x = InternAtom(name);
    return x.ival;
#else  UNION_TYPE
    return int(InternAtom(name));
#endif UNION_TYPE
}

void make_code()
    //
    // δؿǤϡ֥˷ǤʤϤηꡢȥ
    // ֹηꡢؿϤηꡢȹ֥ȤʤɤԤʤ
    // ץȥ뼱̻Ҥηϡ PID Ͽ˹Ԥʤ
    //
    //			 +--------+
    // CodeModule* cp -> |    size|
    //			 +--------+
    //	      code[0] -> |    code| ΰ
    //			 |    objs| ǡΰ ... ֥
    //			 |    tmpl|	       ... 饹ƥץ졼
    //			 +--------+
{
    int i, index, size, value;
    short label;
    int base;
    int tof = 0;	// եå
    int dsz = nof_refer + nof_object;	// ǡΰΥ
    int csz = cof;			// ΰΥ
    //	int tsz = dsz + csz;		// ΤΥ

    // ΰκ
    while (tof < csz) {
	// (1)	̿ФؿϤ¥ɤ˽񤭹ࡣ
	index = tc[tof];	// index ... instruction table Υեå
	base = tof;
	tc[tof++] = instruction_address(index);
	// (2)	̿Υڥɤ¥ɤ˽񤭹ࡣ
	switch (instruction_type(index)) {
	case NO_OP:
	    break;
	case R1_OP:		// [Ri|	      0]
	case R2_OP:		// [Ri|Rj|    0]
	case R3_OP:		// [Ri|Rj|Rk| 0]
	case R4_OP:		// [Ri|Rj|Rk|Rl]
	case R1X1_OP:		// [Ri| 0|   Vx]
	case R2X1_OP:		// [Ri|Rj|   Vx]
	case R32V1_OP:		// [Ri|Rj|Rk|0xff] or [Ri|000000]
	    tof++;
	    break;
	case R1Xe_OP:		// [Ri| 0|   Vx][	  V0][	       L0] ...
	    size = GF_LWX(tc[tof++]);	// entry ǡΥ
	    while (size-- > 0) {	// entry ǡ
		tof++;
		label = fix_label(tc[tof], base, dsz);
		tc[tof++] = label;
	    }
	    break;
	case R1L2_OP:		// [Ri| 0|   L1][   L2|	   0]
	case R2L2_OP:		// [Ri|Rj|   L1][   L2|	   0]
	    value = tc[tof];
	    label = fix_label(GF_LWX(value), base, dsz); // ٥
	    tc[tof++] = SF_LWX(value, label);
	    value = tc[tof];
	    label = fix_label(GF_UPX(value), base, dsz); // ٥
	    tc[tof++] = SF_UPX(value, label);
	    break;
	case R1D1_OP:		// [Ri| 0|   Lr]
	case R2D1_OP:		// [Ri|Rj|   Lr]
	    value = tc[tof];
	    label = fix_refer_label(GF_LWX(value), base, csz+nof_object);
	    tc[tof++] = SF_LWX(value, label);
	    break;
	case R1Da_OP:		// [Ri| 0|   Lr][	  Va]
	    value = tc[tof];
	    label = fix_refer_label(GF_LWX(value), base, csz+nof_object);
	    tc[tof++] = SF_LWX(value, label);
	    tof++;
	    break;
	case R1Db_OP:		// [Ri| 0|   Lr][   Vx|	   0]
	    value = tc[tof];
	    label = fix_refer_label(GF_LWX(value), base, csz+nof_object);
	    tc[tof++] = SF_LWX(value, label);
	    tof++;
	    break;
	case R1Dc_OP:		// [Ri|00|Lo]
	    value = tc[tof];
	    label = fix_obj_label(GF_LWX(value), base, csz);
	    tc[tof++] = SF_LWX(value, label);
	    break;
	case R1Do_OP:		// [Ri| 0|   Lo]
	    value = tc[tof];
	    label = fix_obj_label(GF_LWX(value), base, csz);
	    tc[tof++] = SF_LWX(value, label);
	    break;
	case R1Vi_OP:		// [Ri|	      0][	  V0]
	    tof += 2;
	    break;
	case L1_OP:		// [	     L0]
	    value = tc[tof];
	    label = fix_label(value, base, dsz);
	    tc[tof++] = label;
	    break;
	case RrVp_OP:		// [Ri| 0|   Vn][	  Vp][R0|R1| ... ]
	case RoVp_OP:		// [Ri| 0|   Vn][	  Vp][R0|R1| ... ]
	case RnVp_OP:		// [	0|   Vn][	  Vp][R0|R1| ... ]
	    size = GF_LWX(tc[tof++]);
	    value = tc[tof];
	    if (pid_info_table[value]->pid == UNDEFPID)
		load_error (EP_NOSP, pid_info_table[value]->label);
	    tc[tof++] = (unsigned)pid_info_table[value]->pid.peep();
	    for (; size > 0; size -= 4) tof++;
	    break;
	case RnAf_OP:		// [   Ix|   Vn][R0|R1| ... ]
	    size = GF_LWX (tc[tof++]);
	    for (; size > 0; size -= 4) tof++;
	    break;
	}
    }
    // ǡΰκ
    // ǡΰΥ֥ȤǼΰκ
    for (i = 0; i < nof_object; i++) {
	switch (object_info_table[i]->type) {
	  case OT_STR:	// ʸ
	    tc[tof++] = make_string(object_info_table[i]->u.s);
	    break;
	  case OT_DFL:	// ư
	    tc[tof++] = make_dfloat(object_info_table[i]->u.d);
	    break;
	  default:
	    tc[tof++] = 0;
	    break;
	}
    }
    // ǡΰΥ饹ƥץ졼ȤǼΰκ
    for (i = 0; i < nof_refer; i++) {
	Boolean created;
	Name class_name = refer_info_table[i]->name;
	tc[tof++] = (int) Intern_class_info (class_name, created);
    }
}

/*-----------------
* Local Variables:
* c-argdecl-indent:4
* c-indent-level:4
* c-label-offset:-4
* c-continued-statement-offset:4
* End:
*/
