/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <string.h>
#include "aum/error.h"
#include "aum/alloc.h"
#include "loader/mem.h"

// #define MEM_DEBUG

#ifdef MEM_DEBUG
#include <stdio.h>
#endif

// memory allocation
void   *
memoryall (int sz)
{
    char   *p = SHARED_ALLOC (sz);
    if (p == 0)
	error ("alloc", "Not enough memory");
#ifdef MEM_DEBUG
    fprintf (stderr, "memoryall 0x%x\n", p);
#endif
    return (void *) p;
}

// free memory
void
memoryfree (void *p, int sz)
{
#ifndef NDEBUG
    {
	register char *q = p;
	register int n = sz;
	while (--n >= 0)
	    *q++ = -1;
    }
#endif
#ifdef MEM_DEBUG
    fprintf (stderr, "memoryfree 0x%x\n", p);
#endif
    SHARED_FREE (p, unsigned (sz));
}

const char *
memorysave (const char *f)
{
#ifdef MEM_DEBUG
    fprintf (stderr, "\"%s\"", f);
#endif
    char *t = memoryall (strlen (f) + 1);
    strcpy (t, f);
    return (const char*) t;
}

void
memoryunsave (const char *s)
{
#ifdef MEM_DEBUG
    fprintf (stderr, "\"%s\"", s);
#endif
    memoryfree ((char *) s, strlen (s) + 1);
}

/*-----------------
 * Local Variables:
 * c-argdecl-indent:4
 * c-indent-level:4
 * c-label-offset:-4
 * c-continued-statement-offset:4
 * End:
 */
