/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// lexical and parser error code

#ifndef lyerror_h
#define lyerror_h 1

#define E_TOF	(-1)	/* info table overflow */
#define E_UNDF	(-1)	/* undefine */
#define E_ERR	(-1)	/* lexical error */
#define E_SERR	(-2)	/* slot define error */

// error code
#define EL_IPSI	 0	/* illegal pesudo-instruction */
#define EL_IBEX	 1	/* illegal boolean expression */
#define EL_IREX	 2	/* illegal register expression */
#define EL_ICEX	 3	/* illegal class name expression */
#define EL_UDCH	 4	/* undefine character */
#define EL_LBOF	 5	/* lexical buffer overflow */
#define EL_DIG0	 6	/* can't use a character '\000' */
#define EL_XDIG	 7	/* \x used with no following hex digits */
#define EP_SYNE	 8	/* syntax error */
#define EP_ITOF	 9	/* info table overflow */
#define EP_CDFE 10	/* class definition error */
#define EP_NOSC 11	/* no such class */
#define EP_NOSP 12	/* no such protocol ID */
#define EP_TBOF 13	/* temporary buffer overflow */
#define EP_ISDF 14	/* illegal slot definition */
#define EP_UMFL 15	/* unmatched definition level in foreign lang. */
#define EP_USFL 16	/* unsupported foreign language name */
#define EP_USFP 17	/* unsupported foreign parameter type */
#define EP_TMLP 18	/* too many foreign language parameter */
#define EP_RDFL 19	/* Redeclaration of foreign language definition */
#define EP_UDFL 20	/* Undefined address of foreign language */
#define EP_TMFD 21	/* too many foreign language definition */
#define EP_NOSF 22	/* no such foreign language interface */
#define PE_OVER 23	/* this PE number too big */
#endif

extern void lex_error (int errno, int line, const char* msg);
extern void parse_error (int errno, int line);
extern void parse_system_error (int errno, int line);
extern void load_error (int errno, const char* msg);

/*-----------------
 * Local Variables:
 * c-argdecl-indent:4
 * c-indent-level:4
 * c-label-offset:-2
 * c-continued-statement-offset:4
 * End:
 */
