/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// lexical and parser error function

#include <stream.h>
#include "lyerror.h"

// error message table
static const char *const errmsg[] = {
    "Illegal pseudo-instruction",
    "Illegal boolean expression",
    "Illegal register expression",
    "Illegal class name expression",
    "Undefined character",
    "Lexical buffer overflow",
    "'\\000' used in the middle of a string",
    "\\x used with no following hex digits",
    "Syntax error",
    "Info table overflow",
    "Class definition error",
    "Undefined class defined",
    "Undefined protocol ID",
    "Temporary buffer overflow",
    "Illegal slot definition",
    "Unmatched definition level in foreign language interface",
    "Unsupported foreign language name",
    "Unsupported foreign parameter type",
    "Too many arguments",
    "Redeclaration of foreign language definition",
    "Undefined address of foreign language function",
    "Too many foreign language definition",
    "Undefined foreign language interface",
    "PE number too big",
};

// current assemble file name
extern char* cf_name;

// parsing error counter;
extern int parse_error_count;

// load error flag
extern int load_error_flag;

// lexical part error function
void lex_error(int errno, int line, const char* msg)
//	errno:	顼ֹ
//	line:	ֹ
//	msg:	å
//
// Υ顼򤹤롣
{
    cerr.form("%s:%d: %s: %s.\n", cf_name, line, errmsg[errno], msg);
    parse_error_count++;
}

// parser part error function
void parse_error(int errno, int line)
//	errno:	顼ֹ
//	line:	ֹ
//
// ʸΥ顼򤹤롣
{
    if (line != 0)
	cerr.form("%s:%d: %s.\n", cf_name, line, errmsg[errno]);
    parse_error_count++;
}

// parser part system error function
void parse_system_error(int errno, int line)
//	errno:	顼ֹ
//	line:	ֹ
//
// ʸΥ顼򤹤롣
{
    if (line != 0){
	cerr << "System Error \n";
	cerr.form("%s:%d: %s.\n", cf_name, line, errmsg[errno]);
    }
    parse_error_count++;
}

// load part error function
void load_error(int errno, const char* msg)
//	errno:	顼ֹ
//	msg:	å
//
// ɻȯ顼ν򤹤롣
{
    load_error_flag = 1;
    cerr.form("%s: %s: %s.\n", cf_name, msg, errmsg[errno]);
    return;
}

// yacc error function
void yyerror(const char* s)
//	s:	å
//
// yacc Υ顼ؿ⤷ʤ
{
    return;
}

/*-----------------
 * Local Variables:
 * c-argdecl-indent:4
 * c-indent-level:4
 * c-label-offset:-4
 * c-continued-statement-offset:4
 * End:
 */
