/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/error.h"
#include "class/template.h"
#include "class/slotdict.h"
#include "class/method.h"
#include "class/codemodule.h"
#include "class/foreigndict.h"
#include "class/clink.h"
#include "info.h"

extern Word InternAtom (Name name);
extern SlotDict *MakeSlotDictionary (Uint nslots);
extern MethodDict *MakeMethodDictionary (Uint nmethod);
extern ForeignDict *MakeForeignDictionary (int nforign);
extern CodeModule *MakeCodeModule (Uint ncode, Uint ndata, Uint ntmpl);
extern void make_code ();
extern const char *cf_name;

// load_class()
//
// 饹¤ƥǡ롣
void
load_class ()
{
    Boolean created;
    ClassInfo *cli = Intern_class_info (cc_name, created);
    ClassTmpl *clt = cli->ClassTemplate ();
    if (!created && !clt->DefineOnly ()) {
	fatal (form ("assemble \"%s\"", cf_name),
	       "duplicate class: #%s", clt->Printname ());
    }

    // üåȡüåȤοϿ롣
    clt->SetNofSlots (nof_inlet, nof_slot - nof_inlet);

    // Ѿ饹롣(nof_super ... Ѿ륯饹ο)
    Supers *sup = MakeSupers (nof_super);
    sup->Initialize (cc_name, nof_super, super_info_table,
		     nof_inlet, nof_slot - nof_inlet);
    clt->SetSupers (sup);

    // åȸ롣(nof_slot ... åȤο)
    SlotDict *sdi = MakeSlotDictionary (nof_slot);
    clt->SetSlotDict (sdi);

    // ᥽åɸϢɽ롣(nof_method ... ᥽åɤο)
    MethodDict *mdi = MakeMethodDictionary (nof_method);
    clt->SetMethodDict (mdi);

    ForeignDict *fdi = MakeForeignDictionary (nof_foreign);
    clt->SetForeignDict (fdi);

    // ɡ⥸塼롣
    make_code ();
    CodeModule *com = MakeCodeModule (cof, nof_object, nof_refer);
    clt->SetCodeModule (com);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
