/*- -*- Mode: C -*-						       -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef loader_info_h
#define loader_info_h

#include "aum/word.h"
#include "aum/protocolid.h"

/* assembler infomation structure */

static const int UNDEF = -1;	/* undefine label offset */
static const ProtocolID UNDEFPID ((unsigned) UNDEF);
static const ProtocolID EMP_PID (0);	/* undefine label offset */

/* undefine protocol ID */
#define OT_STR	1		/* object type = string */
#define OT_DFL	2		/* object type = double float */

#define ST_INLET  0		/* inlet slot */
#define ST_OUTLET 1		/* outlet slot */

/* bool */
#define BT_TRUE	 0		/* boolean true */
#define BT_FALSE 1		/* boolean false */

/* entry data */
#define ED_ATOM	 4		/* entry data is atom */

/* table size */
#define PID_TSZ 1024		/* pid info table size */
#define SLOTTSZ 1024		/* slot info table size */
#define SUPRTSZ 1024		/* super class info table size */
#define REFRTSZ 1024		/* reference class info table size */
#define MTHDTSZ 1024		/* method info table size */
#define LABLHSZ	 509		/* label hash table size */
#define LABLTSZ 1024		/* label info table size */
#define ATOMTSZ 1024		/* atom info table size */
#define OBJCTSZ 1024		/* object info table size */
#define FLANGSZ	 128		/* foreign language interface table size */
#define ASCODSZ 8192		/* temporary code size */
#define MAXIOSZ 11		/* maxmum instruction operand size */

/* for jis_to_euc & strcount begin */
#define ESCAPE	    '\033'
#define KIFIRST	    '$'
#define DEFAULTKI   'B'
#define KOFIRST	    '('
#define DEFAULTKO   'J'

#ifndef KICHAR
#define KICHAR DEFAULTKI
#endif
#ifndef KOCHAR
#define KOCHAR DEFAULTKO
#endif

/* for	       jis_to_euc & strcount end	    */
struct pid_info {
    const char *label;		/* label name */
    const char *name;		/* protocol name */
    char    arity;		/* protocol arity */
    u_long  mode;		/* protocol mode */
    ProtocolID pid;		/* protocol ID */
};

struct slot_info {
    const char *name;		/* slot name */
    char    type;		/* slot type INLET=0, OUTLET=1 */
    short   offset;		/* offset */
};

struct refer_info {
    const char *label;		/* label name */
    const char *name;		/* class name */
};

struct method_info {
    const char *label;		/* method name */
    int	    pid_idx;		/* index of pid_info_tablep[] */
    const char *name;		/* method name - mode */
    u_long  mode;		/* method mode */
    u_char  arity;		/* method arity */
    short   offset;		/* method entry */
};

struct label_info {
    const char *name;		/* label name */
    int	    offset;		/* label offset */
    struct label_info *next;	/* label hash next chain */
};

struct atom_info {
    const char *name;		/* print name */
    u_long  atom_no;		/* atom number */
};

struct string_info {
    short   nbytes;		/* # of bytes */
    short   nchars;		/* # of chars (include EUC code) */
    char   *elements;		/* string element */
};

struct object_info {
    int	    type;		/* object type */
    union {
	struct string_info *s;	/* string */
	double	d;		/* double float */
    }	    u;
};

class ForeignNameList;
struct foreign_info {
    const char	 *label;	/* label name */
    ForeignNameList *fnlp;	/* foreign namelist  */
};

typedef struct pid_info PidInfo;
typedef struct slot_info SlotInfo;
typedef char SuperInfo;
typedef struct refer_info ReferInfo;
typedef struct method_info MethodInfo;
typedef struct label_info LabelInfo;
typedef struct atom_info AtomInfo;
typedef struct object_info ObjectInfo;
typedef struct string_info StringInfo;
typedef struct foreign_info ForeignInfo;

typedef struct pid_info *PidInfop;
typedef struct slot_info *SlotInfop;
typedef const char *SuperInfop;
typedef struct refer_info *ReferInfop;
typedef struct method_info *MethodInfop;
typedef struct label_info *LabelInfop;
typedef struct atom_info *AtomInfop;
typedef struct object_info *ObjectInfop;
typedef struct string_info *StringInfop;
typedef struct foreign_info *ForeignInfop;

extern int nof_pid;		/* number of protocol ID */
extern int nof_slot;		/* number of slots */
extern int nof_inlet;		/* number of inlet slots */
extern int nof_outlet;		/* number of outlet slots */
extern int nof_super;		/* number of super class */
extern int nof_refer;		/* number of reference class */
extern int nof_method;		/* number of method */
extern int nof_label;		/* number of label */
extern int nof_atom;		/* number of atom */
extern int nof_object;		/* number of object */
extern int nof_foreign;		/* number of foreign */

extern PidInfop *pid_info_table;
extern SlotInfop *slot_info_table;
extern SuperInfop *super_info_table;
extern ReferInfop *refer_info_table;
extern MethodInfop *method_info_table;
extern LabelInfop *label_info_hash;
extern LabelInfo *label_info_table;
extern AtomInfop *atom_info_table;
extern ObjectInfop *object_info_table;
extern ForeignInfop *foreign_info_table;
extern int *tc;

extern int parse_outlet;	/* parsing outlet slot */

extern int cof;			/* current code offset */
extern const char *cc_name;	/* current class name */
extern int line;

extern void initialize_info ();
extern void finalize_info ();
extern void initialize_volatile_slot ();
extern int add_pid_info (const char *, const char *, int, u_long);
extern int add_pid_info_primitive (const char *, int prim);
extern int add_slot_info (const char *, int);
extern int add_super_info (const char *);
extern int add_refer_info (const char *, const char *);
extern int add_method_info (const char *, const char *, int, u_long, int);
extern int add_method_info_primitive (const char *, int, int);
extern int add_method_info_system (const char *lable, int);
extern int add_label_info (const char *, int);
extern int add_atom_info (const char *);
extern int add_string_info (char *elems);
extern int add_dfloat_info (double d);
extern int look_refer_info (const char *);
extern int look_pid_info (const char *);
extern int look_slot_info (const char *);
extern int look_foreign_info (const char *);
extern int make_aum_boolean (int type);
extern int make_aum_integer (int value);
extern int make_aum_float (float value);
extern void parse_error (int errno, int line);
extern void yyerror (const char *s);
extern int yylex ();
extern void load_class ();

extern void foreign_definition (const char *, const char *);
extern void foreign_name (const char *);
extern void foreign_arg (const char *);
extern void foreign_return (const char *);
extern void foreign_end ();

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif				/* !loader_info_h */
