/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// info table handling function

#include <assert.h>
#include "aum/word.h"
#include "aum/types.h"
#include "aum/protocolid.h"
#include "aum/error.h"
#include "info.h"
#include "lyerror.h"
#include "utils/utils.h"
#include "table/nlist.h"
#include "loader/mem.h"

extern ProtocolID intern_pid (Name name, u_char arity, u_long modes);
extern Word InternAtom (Name name);
extern int fix_atom_id (Name name);
extern void gc_info_table2 ();

// line counter
extern int line;

// constant
static const char *VS_CREATOR = "creator";
static const char *VS_RESULT = "result";

/* foreign definition level; for error check */
int  foreign_level;

inline int
string_equal (register const char *s1, register const char *s2)
{
    while (*s1 == *s2++)
	if (*s1++ == '\0')
	    return 1;
    return 0;
}

void
initialize_info ()
//
// info data ν򤹤롣饹λϤǸƤӽФ롥
{
    nof_slot = 0;
    nof_inlet = 0;
    nof_outlet = 0;
    nof_super = 0;
    nof_refer = 0;
    nof_method = 0;
    nof_label = 0;
    nof_object = 0;
    nof_foreign = 0;
    parse_outlet = 0;
    cof = 0;
    foreign_level = 0;
}

void
finalize_info ()
//
// info data ǻѤ줿ΰβ򤹤롣饹κǸǸƤ
// Ф롥
{
    if (foreign_level != 0) {
	parse_error (EP_UMFL, line);
    }
    gc_info_table2 ();
}

int
add_pid_info (const char *label, const char *name, int arity, u_long mode)
// label:	PIDΥ٥̾
// name:	PID̾
// arity:	Ŀ
// mode:	⡼
//
// PID ơ֥˲ä롣Ǥ label Ʊ̾Ͽ
// Ƥ顢 PID 򤫤 label ϿƤˤ⤫
// 餺 PID ̤λϡ PID ꤷƤ顢֤ͤ
// label Ʊ̾ϿƤʤϡϿ PID
// ֤
{
    PidInfop p;
    assert (arity > 0);
    for (int i = nof_pid - 1; i >= 0; --i) {
	p = pid_info_table[i];
	if (string_equal (label, p->label)) {
	    if (p->pid == UNDEFPID) {
		memoryunsave (label);
		p->name = name;
		p->arity = arity;
		p->mode = mode;
		p->pid = intern_pid (name, arity, mode);
		return i;
	    }
	    else {
		memoryunsave (label);
		memoryunsave (name);
		return i;
	    }
	}
    }
    if (nof_pid >= PID_TSZ)
	return UNDEF;
    p = (PidInfop) memoryall (sizeof (PidInfo));
    p->label = label;
    p->name = name;
    p->arity = arity;
    p->mode = mode;
    p->pid = intern_pid (name, arity, mode);
    pid_info_table[nof_pid] = p;
    return nof_pid++;
}

int
add_pid_info_primitive (const char *label, int prim)
// label:	PIDΥ٥̾
// prim:	ܥǡΥ֥
//
// ܥǡ PID ơ֥˲ä롣Ǥ label Ʊ
// ̾ϿƤ顢 PID  index 򤫤label 
// ϿƤˤ⤫餺 PID ̤λϡ PID ꤷ
// 顢֤ͤlabel Ʊ̾ϿƤʤϡ
// Ͽ PID index ֤
{
    PidInfop p;
    for (int i = 0; i < nof_pid; i++) {
	p = pid_info_table[i];
	if (string_equal (label, p->label)) {
	    if (p->pid == UNDEFPID) {
		memoryunsave (label);
		p->name = 0;
		p->arity = 0;
		p->mode = 0;
		p->pid = prim;
		return i;
	    }
	    else {
		memoryunsave (label);
		return i;
	    }
	}
    }
    if (nof_pid >= PID_TSZ)
	return UNDEF;
    p = (PidInfop) memoryall (sizeof (PidInfo));
    p->label = label;
    p->name = 0;
    p->arity = 0;
    p->mode = 0;
    p->pid = prim;
    pid_info_table[nof_pid] = p;
    return nof_pid++;
}

int
add_slot_info (const char *name, int type)
// name:	å̾
// type:	åȤη
//
// åȾơ֥˲ä롣å¤ӽ礬ˡʻ
// inlet ¤Ӥθ outlet ¤Ǥʤˤϡ顼ɤ
// ֤
{
    SlotInfop s;
    if (parse_outlet && type == ST_INLET)
	return E_SERR;
    if (nof_slot >= SLOTTSZ)
	return E_TOF;
    if (type == ST_OUTLET && !parse_outlet) {
	parse_outlet = 1;	// parsing outlet slot flag = TRUE

    }
    s = (SlotInfop) memoryall (sizeof (SlotInfo));
    slot_info_table[nof_slot] = s;
    s->name = name;
    s->type = type;
    s->offset = (type == ST_INLET) ? nof_inlet++ : nof_outlet++;
    nof_slot++;
    return 0;
}

int
add_super_info (const char *name)
// name:	Ѿ饹̾
//
// Ѿ饹ơ֥˲ä롥
{
    if (nof_super >= SUPRTSZ)
	return E_TOF;
    super_info_table[nof_super++] = name;
    return 0;
}

int
add_refer_info (const char *label, const char *name)
// label:	٥̾
// name:	ȥ饹̾
//
// ȥ饹ơ֥˲ä롥
{
    ReferInfop r;
    if (nof_refer >= REFRTSZ)
	return E_TOF;
    r = (ReferInfop) memoryall (sizeof (ReferInfo));
    refer_info_table[nof_refer++] = r;
    r->label = label;
    r->name = name;
    return 0;
}

int
add_method_info (const char *label, const char *name, int arity, u_long mode, int offset)
// label:	᥽åɤΥ٥̾
// name:	᥽å̾
// arity:	Ŀ
// mode:	Υ⡼
// offset:	᥽åɤΥ⥪ե
//
// ᥽åɾơ֥˲ä롣ޤ᥽åɤ PID ꤷ
// pid_info_table  PIDϿ롥
{
    assert (arity > 0);
    MethodInfop m;
    if (nof_method >= MTHDTSZ)
	return UNDEF;
    m = (MethodInfop) memoryall (sizeof (MethodInfo));
    method_info_table[nof_method++] = m;
    m->label = label;
    m->name = name;
    m->arity = arity;
    m->mode = mode;
    m->pid_idx = add_pid_info (label, name, arity, mode);
    m->offset = offset;
    return nof_method;
}

int
add_method_info_primitive (const char *label, int prim, int offset)
// label:	᥽åɤΥ٥̾
// prim:   ܥǡ֥
// offset:	᥽åɤΥ⥪ե
//
// ܥǡΥ᥽åɾơ֥˲ä롣ޤ᥽åɤ
// PID ꤷ pid_info_table  PIDϿ롥
{
    MethodInfop m;
    if (nof_method >= MTHDTSZ)
	return UNDEF;
    m = (MethodInfop) memoryall (sizeof (MethodInfo));
    method_info_table[nof_method++] = m;
    m->label = label;
    m->name = 0;
    m->arity = 0;
    m->mode = 0;
    m->pid_idx = add_pid_info_primitive (label, prim);
    m->offset = offset;
    return nof_method;
}

int
add_method_info_system (const char *name, int offset)
// name:	᥽å̾
// offset:	᥽åɤΥ⥪ե
//
// ᥽åɾơ֥˲ä롣ޤ᥽åɤ PID ꤷ
// pid_info_table  PIDϿ롥
{
    int	    len = strlen (name) + 1;
    char   *label = memoryall (len);
    strcpy (label, name);
    Word    atom = InternAtom (name);
    int	    status = add_method_info_primitive (label, atom, offset);
    if (status == E_TOF)
	return status;
    label = memoryall (len);
    strcpy (label, name);
    status = add_label_info (label, offset);
    return status;
}

int
add_label_info (const char *name, int offset)
// name:	٥̾
// offset:	٥Υ⥪ե
//
// ٥ơ֥˲ä롣Ǥˡname Ʊ̾Ͽ
// ƤˤϡΥ٥ label_info_table ⥪եåȤ
// name ϿƤʤϡϿ롥
{
    register unsigned hval = 0;
    register const char *s = name;
    register int ln = 0;
    while (*s) {
	hval = (hval << 1) + *s++;
	ln++;
    }
    hval %= LABLHSZ;
    LabelInfop lab = label_info_hash[hval];
    while (lab) {
	if (string_equal (lab->name, name)) {
	    if (offset != UNDEF)
		lab->offset = offset;
	    memoryunsave (name);
	    return lab - &label_info_table[0];
	}
	lab = lab->next;
    }
    if (nof_label >= LABLTSZ)
	return E_TOF;
    lab = &label_info_table[nof_label++];
    lab->name = name;
    lab->offset = offset;
    lab->next = label_info_hash[hval];
    label_info_hash[hval] = lab;
    return lab - &label_info_table[0];
}

int
add_atom_info (const char *name)
// name:	ȥ̾
//
// ȥơ֥˲ä롣Ǥˡname Ʊ̾Ͽ
// Ƥ顢Υȥֹ֤ϿƤʤϡ
// Ͽȥֹ֤
{
    AtomInfop a;
    for (int i = 0; i < nof_atom; i++) {
	a = atom_info_table[i];
	if (string_equal (a->name, name)) {
	    memoryunsave (name);
	    return a->atom_no;
	}
    }
    if (nof_atom >= ATOMTSZ)
	return E_TOF;
    a = (AtomInfop) memoryall (sizeof (AtomInfo));
    atom_info_table[nof_atom++] = a;
    a->name = name;
    a->atom_no = fix_atom_id (name);
    return a->atom_no;
}

int
add_string_info (char *elems)
// elems:	ʸʣݡѴƤ
//
// ʸơ֥˲ä롥
{
    ObjectInfop o;
    if (nof_object >= OBJCTSZ)
	return E_TOF;
    o = (ObjectInfop) memoryall (sizeof (ObjectInfo));
    object_info_table[nof_object] = o;
    o->type = OT_STR;
    o->u.s = (struct string_info *) memoryall (sizeof (struct string_info));
    o->u.s->nchars = jstrlen ((u_char *) elems);
    o->u.s->nbytes = strlen (elems);
    o->u.s->elements = elems;
    return nof_object++;
}

int
add_dfloat_info (double d)
// double:	ư
//
// ươ֥˲ä롥
{
    ObjectInfop o;
    if (nof_object >= OBJCTSZ)
	return E_TOF;
    o = (ObjectInfop) memoryall (sizeof (ObjectInfo));
    object_info_table[nof_object] = o;
    o->type = OT_DFL;
    o->u.d = d;
    return nof_object++;
}

int
look_pid_info (const char *s)
// s:	ʸ
//
// ʸ s Ʊ٥PID õƱ٥PID
// 󤬸ĤäϡΥ٥ pid_info_table ⥪ե
// ֤Ĥʤäϡ PID Ͽ pid_
// info_table ⥪եåȤ֤
{
    PidInfop p;
    for (int i = nof_pid - 1; i >= 0; --i) {
	p = pid_info_table[i];
	if (string_equal (s, p->label)) {
	    memoryunsave (s);
	    return i;
	}
    }
    if (nof_pid >= PID_TSZ)
	return E_TOF;
    p = (PidInfop) memoryall (sizeof (PidInfo));
    p->label = s;
    p->pid = UNDEFPID;
    p->name = 0;
    p->arity = 0;
    p->mode = 0;
    pid_info_table[nof_pid] = p;
    return nof_pid++;
}

int
look_refer_info (const char *s)
// s:	ʸ
//
// ʸ s Ʊ̾Ļȥ饹õƱ̾Υ٥뤬
// ĤäϡΥ٥ refer_info_table ⥪եåȤ
// Ĥʤäϥ顼ɤ֤
{
    int	    i;
    for (i = 0; i < nof_refer; i++)
	if (string_equal (s, refer_info_table[i]->label))
	    return i;
    return E_UNDF;
}

int
look_slot_info (const char *s)
// s:	ʸ
//
// ʸ s Ʊ̾ĥåȤõƱ̾ΥåȤ
// ĤäϡΥåȤ slot_info_table ⥪եåȤ
// ֤Ĥʤäϡ顼ɤ֤
{
    int	    i;
    for (i = 0; i < nof_slot; i++)
	if (string_equal (s, slot_info_table[i]->name))
	    return slot_info_table[i]->offset;
    return E_UNDF;
}

void
initialize_volatile_slot ()
//
// Volatile ΥåȤν򤹤롥
{
    int	    status0, status1;
    char   *s0 = memoryall (strlen (VS_CREATOR) + 1);
    strcpy (s0, VS_CREATOR);
    char   *s1 = memoryall (strlen (VS_RESULT) + 1);
    strcpy (s1, VS_RESULT);
    status0 = add_slot_info (s1, ST_INLET);
    status1 = add_slot_info (s0, ST_OUTLET);
    return;
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
//
// Ū¾쥤󥿥եξ롥ξȤäơ¾
// ơ֥Ͽ롥¿Υåϥơ֥Ͽ˹
// ʤ
static ForeignNameList *foreign_infp;

/* current number of args */
static int foreign_nargs;

static const char* foreign_current_label;

static void
new_foreign_tmpl ()
{
    foreign_infp = (ForeignNameList *) memoryall (sizeof (ForeignNameList));
    FPType *pts = memoryall (sizeof (FPType) * FOREIGN_MAXARGS);
    foreign_infp->ParaTypes (pts);
}

static void
delete_foreign_tmpl ()
{
    const char *s = foreign_infp->Name ();
    memoryfree ((char *) s, strlen (s) + 1);
    memoryfree (foreign_infp->ParaTypes (), sizeof (FPType) * FOREIGN_MAXARGS);
    memoryfree (foreign_infp, sizeof (ForeignNameList));
}

void
foreign_definition (const char* langname, const char *label)
    // {}
    // ¾νԤʤǽˡΥ٤
    // Ĵ٤롥ˡ̾ɤĴ٤롥ʾ
    // ϡѤΥƥץ졼Ȥΰݤηֵͤ
    // åȤ롥ֵͤ򥻥åȤΤϡ̵ֵͤä
    // VOID Ȥ٤Ǥ롥ޤοѿ foreing_nargs
    //  0 ˽롥
    // {}
{
    if (NameList_load_p == FALSE) {
	error ("foreign_load",
	       "The nlist has't been loaded, use `-nlist' option.");
    }
    foreign_level++;
    if (foreign_level > 1) {
	parse_error (EP_UMFL, line);
	foreign_level = 0;
	return;
    }
    FLType type = Foreign_language (langname);
    if (type == FL_ERROR) {
	parse_error (EP_USFL, line);
	return;
    }
    new_foreign_tmpl ();
    foreign_infp->LanguageType (type);
    foreign_infp->ReturnType (FP_VOID);
    foreign_nargs = 0;
    foreign_current_label = memorysave (label);
    /* printf ("begin %s, %s\n", langname, label); */
}

static int
add_foreign_info (const char *label, ForeignNameList *np)
{
    ForeignInfop p;
    for (int i = 0; i < nof_foreign; i++) {
	p = foreign_info_table[i];
	if (string_equal (label, p->label)) {
	    parse_error (EP_RDFL, line);
	    return -1;
	}
    }
    if (nof_foreign >= FLANGSZ) {
	parse_error (EP_TMFD, line);
	return -1;
    }
    p = (ForeignInfop) memoryall (sizeof (ForeignInfo));
    p->label = label;
    p->fnlp = np;
    foreign_info_table[nof_foreign] = p;
    return nof_foreign++;
}

void
foreign_end ()
    // {}
    // ¾쥤󥿥եκǽԤʤǽΥ٥뤬
    // ȤɤĴ٤롥ˡθĿꤹ롥Ǹˡ
    // ƥץ졼Ȥ򥰥Х¾쥤󥿥եơ֥Ͽ
    // 򤹤롥Ǥʤˤϥ顼Ȥ롥
    // {}
{
    --foreign_level;
    if (foreign_level < 0) {
	parse_error (EP_UMFL, line);
	foreign_level = 0;
	return;
    }
    foreign_infp->Arity (foreign_nargs);
    /* dump_foreign_namelist (foreign_infp); */
    {
	FLEstatus status;
	ForeignNameList *np = Intern_NameList (foreign_infp, status);
	switch (status) {
	case FLE_MULTI:
	    parse_error (EP_RDFL, line);
	    break;
	case FLE_UNDEF:
	    parse_error (EP_UDFL, line);
	    break;
	default:
	    add_foreign_info (foreign_current_label, np);
	    break;
	}
    }
    delete_foreign_tmpl ();
    /* printf ("end\n"); */
}

void
foreign_name (const char *name)
    // {}
    // ¾δؿ̾򥻥åȤ롥name ΰ foreign_end () ǲ
    // 롥
    // {}
{
    foreign_infp->Name (memorysave (name));
    /* printf ("name \"%s\"\n", name); */
}

void
foreign_arg (const char *label)
    // {}
    // ¾δؿΰ򥻥åȤ롥ν֤ foreign_nargs ǻ
    // ꤹ롥label ϰηɽʸǤ롥ΰϤΤ
    // ɬ̵Τǲ롥
    // {}
{
    FPType type = Foreign_parameter (label);
    if (type == FP_ERROR) {
	parse_error (EP_USFP, line);
	return;
    }
    if (foreign_nargs >= FOREIGN_MAXARGS) {
	parse_error (EP_TMLP, line);
	return;
    }
    FPType *pts = foreign_infp->ParaTypes ();
    pts[foreign_nargs++] = type;
    /* printf ("arg %s\n", label); */
}

void
foreign_return (const char *label)
    // {}
    // ¾ͤη򥻥åȤ롥label ϰηɽʸ
    // 롥ΰϤΤɬ̵Τǲ롥
    // {}
{
    FPType type = Foreign_parameter (label);
    if (type == FP_ERROR) {
	parse_error (EP_USFP, line);
	return;
    }
    foreign_infp->ReturnType (type);
    /* printf ("return %s\n", label); */
}

int
look_foreign_info (const char *label)
{
    for (int i = 0; i < nof_foreign; i++) {
	const ForeignInfop p = foreign_info_table[i];
	if (string_equal (label, p->label))
	    return i;
    }
    return E_UNDF;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
