/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// field access macro

#ifndef field_h
#define field_h 1

// field maker
#define SF_BYTE4(_a,_b,_c,_d) ((((_a)&0xFF)<<24)|(((_b)&0xFF)<<16)|\
			       (((_c)&0xFF)<<8)|((_d)&0xFF))
#define SF_BYTE2X(_a,_b,_c)   ((((_a)&0xFF)<<24)|(((_b)&0xFF)<<16)|\
			       ((_c)&0xFFFF))
#define SF_BYTEXX(_a,_b)      ((((_a)&0xFFFF)<<16)|((_b)&0xFFFF))
#define PE_BSHIFT(x)  ((x)<<8)
#define GF_UPX(_a)	(((_a)>>16)&0xFFFF)
#define GF_LWX(_a)	((_a)&0xFFFF)
#define SF_UPX(_a,_b)	(((_a)&0xFFFF)|(((_b)&0xFFFF)<<16))
#define SF_LWX(_a,_b)	(((_a)&0xFFFF0000)|((_b)&0xFFFF))

#define GF_BY0(_a)	(((_a)>>24)&0xFF)
#define GF_BY1(_a)	(((_a)>>16)&0xFF)
#define GF_BY2(_a)	(((_a)>> 8)&0xFF)
#define GF_BY3(_a)	((_a)&0xFF)

// mask
#define MK_16	0xFFFF
#define MK_08	0xFF
#define MK_05	0x1F
#define PEMAX	256
#endif

/*-----------------
 * Local Variables:
 * c-argdecl-indent:4
 * c-indent-level:4
 * c-label-offset:-4
 * c-continued-statement-offset:4
 * End:
 */
