/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef disasm_h
#define disasm_h 1

#include "class/codemodule.h"

extern const char* disasm(Uint* xo);

class CodeModule;

// ե֥
class DisAssembler {
  private:
    Uint*	offset; // ߤΥɡեå
    CodeModule* cp;	// 
  public:
    DisAssembler();
    DisAssembler(CodeModule* xc);
    ~DisAssembler();

    Uint*	Get_offset();
    CodeModule* Get_code();
    void	Set_offset(Uint* xo);
    void	Set_code(CodeModule* xc);

    const char* dis_assemble();
};

inline DisAssembler::DisAssembler()
{
    offset = 0; cp = 0;
}

inline DisAssembler::DisAssembler(CodeModule* xc)
{
    offset = &xc->code[0]; cp = xc;
}

inline DisAssembler::~DisAssembler()
{
}

inline Uint* DisAssembler::Get_offset()
{
    return offset;
}

inline CodeModule* DisAssembler::Get_code()
{
    return cp;
}

inline void DisAssembler::Set_offset(Uint* xo)
{
    offset = xo;
}

inline void DisAssembler::Set_code(CodeModule* xc)
{
    cp = xc;
}

#endif

/*-----------------
 * Local Variables:
 * c-argdecl-indent:4
 * c-indent-level:4
 * c-label-offset:-4
 * c-continued-statement-offset:4
 * End:
 */
