/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/aumtype.h"
#include "aum/object.h"
#include "aum/word.h"
#include "aum/types.h"
#include "aum/protocolid.h"
#include "aum/tstream.h"

#include "class/template.h"
#include "class/clink.h"
#include "funadd.gh"
#include "disasm.h"
#include "rgline.h"
#include "parse.h"
#include "field.h"
#include "builtin/extern.h"
#include "table/nlist.h"

extern Name AtomPrintname(Word atom);
extern char* find_instruction_name(int e, int* type);
extern char* preg(int rn);

extern "C" {
int strlen(const char* s);
char* strcpy(char* s1, const char* s2);
}

// ɤνɽ
#define EndOfCode (char*)0

// 顼ɽʸ
static const char* IllegalCode = "illegal code";
static const char* IllegalObjs = "illegal object";
static const char* NotDisAssemble = "Can not disassemble";

// Buffer Size
const int ENTRYPMAX = 8;	// entry print maximum
const int RGBUFSZ = 160;	// register line print buffer size
// 160 = Unit * 32, Uint = ", R00" = 5
const int EPBUFSZ = 32 * ENTRYPMAX;	// entry print buffer size
// 32 = entry ...;

// char* class_print_image(Uint e)
//	e:	饹ƥץ졼ȤؤΥݥ󥿤ɽ
//
// 饹ƥץ졼 e Υ饹̾ΰɽ֤
static char*
class_print_image(Uint e)
{
    ClassInfo* cip = (ClassInfo*)e;
    char tem[BUFSIZ];
    tstream tout = tstream(BUFSIZ, tem);
    tout.form("#%s", (char*)AtomPrintname(cip->ClassName()));
    return tout.Result();
}

// char* foreign_print_image (Uint e)
//	e:	ե󥪥֥ȤؤΥݥ󥿤ɽ
//
// ե󥪥֥ e ΰɽ֤
static char*
foreign_print_image (Uint index)
{
    const ForeignNameList* np = CurrentClass->ForeignInfo (index);
    char tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    tout.form("\"%s ()\"", np->Name ());
    return tout.Result();
}

// char* pr_print_image(Uint e)
//	e:	ǣգܥ֥
//
// ǣգܥ֥Ȥΰɽ֤
static char*
pr_print_image(Uint e)
{
#ifdef UNION_TYPE
    Word x;
    x.ival = e;
#else  UNION_TYPE
    Word x = e;
#endif UNION_TYPE
    char tem[BUFSIZ];
    tstream tout = tstream(BUFSIZ, tem);
    switch(Type_of(x))
	{
	  case AUm_Fixnum:
	    tout.form("%d", Fix2Int(int(x)));
	    break;
	  case AUm_Atom:
	    tout << (char*)AtomPrintname(x);
	    break;
	  case AUm_Constant:
	    if(IsSFloat(x))
		{
		    tout.form("0f%e", Single2float(x));
		}
	    if (IsBool(x)) {
		if (IsTrue(x)) tout << "`true";
		else tout << "`false";
	    }
	    break;
	  default:
	    tout << "primitive object";
	    break;
	}
    return tout.Result();
}

// char* bo_print_image(Uint e)
//	e:	ǣգȹ֥
//
// ǣգȹ֥Ȥΰɽ֤
static const char*
bo_print_image(Uint e)
{
#ifdef UNION_TYPE
    Word x;
    x.ival = e;
#else  UNION_TYPE
    Word x = e;
#endif UNION_TYPE
    switch(Type_of(x))
	{
	  case AUm_Object:
	    switch(ObjectType(x))
		{
		case WC_ASCII_STR:
		case ASCII_STR:
		case EUC_STR:
		case WC_EUC_STR:
		case DFLOAT:
		    return (char*)print(x);
		default:
		    break;
		}
	    break;
	  default:
	    break;
	}
    return IllegalObjs;
}
// char* pregline(const Uint *const oa, int size)
//	oa:	
//	size:	쥸ο
//
// ѸĤΥ쥸̿ΰɽ֤
static const char*
pregline(const Uint *const oa, int size)
{
    static char rgbuf[RGBUFSZ];
    if (size == 0) return "";
    char* p0 = rgbuf;
    u_char* rp = (u_char*)oa;

    while (--size >= 0) {
	char* name = preg(*rp++);
	*p0++ = ',', *p0++ = ' ';
	while (*name != '\0') *p0++ = *name++;
    }
    *p0 = '\0';
    return rgbuf;
}

// char* entry_print_image(const Uint *const oa, int size)
//	oa:	ɥ쥹
//	size:	ȥ꡼ο
//
// ȥ꡼̿ե֥뤷ΰɽ֤
static char*
entry_print_image(const Uint *const oa, int size)
{
    static char epbuf[EPBUFSZ];
    Uint e1, e2;
    char* p = epbuf;
    int max = ( size > ENTRYPMAX ? ENTRYPMAX : size ) * 2;
    for (int i = 0; i < max; i += 2) {
	e1 = oa[i+0];
	e2 = oa[i+1];
	p = strcpy(p, form(".entry %s, $%d", pr_print_image(e1), e2));
	p += strlen(p);
    }
    if (size-ENTRYPMAX > 0) {
	p = strcpy(p, " ...");
	p += strlen(p);
    }
    *p = '\0';
    return epbuf;
}

// char* dis_assemble_code(Uint* oa, int* na);
//	oa:	ե֥Ϥ륢ɥ쥹
//	na:	˵ե֥뤹륢ɥ쥹 - oa
//
// ΰե֥뤷ΰɽ֤
#ifdef PAS_DEBUGGER
const char*
dis_assemble_code(const Instruction *const oa, int* na)
#else
static const char*
dis_assemble_code(const Instruction *const oa, int* na)
#endif
{
#undef CM
#define CM << ", "
    int type, size;
    Uint e1, e2;
    char* epi;
    char* np = find_instruction_name(oa[0], (int*)&type);
    if (np == 0) return NotDisAssemble;

    char tem[BUFSIZ];
    tstream tout = tstream(BUFSIZ, tem);
    tout << np;
    if (type != NO_OP)
	tout << "  ";
    switch (type) {
    case NO_OP:
	*na = 1;
	break;
    case R1_OP:
	e1 = oa[1];
	*na = 2;
	tout << preg(GF_BY0(e1));
	break;
    case R2_OP:
	e1 = oa[1];
	*na = 2;
	tout << preg(GF_BY0(e1)) CM << preg(GF_BY1(e1));
	break;
    case R3_OP:
	e1 = oa[1];
	*na = 2;
	tout << preg(GF_BY0(e1)) CM << preg(GF_BY1(e1)) CM << preg(GF_BY2(e1));
	break;
    case R4_OP:
	e1 = oa[1];
	*na = 2;
	tout << preg(GF_BY0(e1)) CM << preg(GF_BY1(e1))
	    CM << preg(GF_BY2(e1)) CM << preg(GF_BY3(e1));
	break;
      case R1X1_OP:
	e1 = oa[1];
	*na = 2;
	tout << preg(GF_BY0(e1)) CM << GF_LWX(e1);
	break;
      case R2X1_OP:
	e1 = oa[1];
	*na = 2;
	tout << preg(GF_BY0(e1)) CM << GF_LWX(e1) CM << preg(GF_BY1(e1));
	break;
      case R1Xe_OP:
	e1 = oa[1];
	size = GF_LWX(e1);
	*na = 2 + (size * 2);
	epi = entry_print_image(oa+2, size);
	tout << preg(GF_BY0(e1)) CM << size CM << epi;
	break;
      case R1L2_OP:
	e1 = oa[1];
	e2 = oa[2];
	*na = 3;
	tout << preg(GF_BY0(e1)) CM;
	tout.form("$%d, $%d", GF_LWX(e1), GF_UPX(e2));
	break;
      case R2L2_OP:
	e1 = oa[1];
	e2 = oa[2];
	*na = 3;
	tout << preg(GF_BY0(e1)) CM << preg(GF_BY1(e1)) CM;
	tout.form("$%d, $%d", GF_LWX(e1), GF_UPX(e2));
	break;
      case R1D1_OP:
	e1 = oa[1];
	*na = 2;
	tout << preg(GF_BY0(e1)) CM << class_print_image(oa[GF_LWX(e1)]);
	break;
      case R2D1_OP:
	e1 = oa[1];
	*na = 2;
	tout << preg(GF_BY0(e1)) CM << preg(GF_BY1(e1)) CM
	    << class_print_image(oa[GF_LWX(e1)]);
	break;
      case R1Da_OP:
	e1 = oa[1];
	e2 = oa[2];
	*na = 3;
	tout << preg(GF_BY0(e1)) CM
	    << class_print_image(oa[GF_LWX(e1)]) CM << pr_print_image(e2);
	break;
      case R1Db_OP:
	e1 = oa[1];
	e2 = oa[2];
	*na = 3;
	tout << preg(GF_BY0(e1)) CM;
	tout.form("%s!%d", class_print_image(oa[GF_LWX(e1)]), GF_UPX(e2));
	break;
      case R1Dc_OP:
	e1 = oa[1];
	*na = 2;
	tout <<	 preg(GF_BY0(e1)) CM << bo_print_image(oa[GF_LWX(e1)]);
	break;
      case R1Do_OP:
	e1 = oa[1];
	*na = 2;
	tout << preg(GF_BY0(e1)) CM << bo_print_image(oa[GF_LWX(e1)]);
	break;
      case R1Vi_OP:
	e1 = oa[1];
	e2 = oa[2];
	*na = 3;
	tout << preg(GF_BY0(e1)) CM << pr_print_image(e2);
	break;
      case L1_OP:
	e1 = oa[1];
	*na = 2;
	tout.form("$%d;", e1);
	break;
      case RoVp_OP:
	e1 = oa[1];
	e2 = oa[2];
	size = GF_LWX(e1);
	*na = 3 + (size+3)/4;
	//					      no comma
	ProtocolID po = (ProtocolID)e2;
	tout << preg(GF_BY0(e1)) CM << po.Printname();
	tout << pregline(oa+3, size);
	break;
      case RnVp_OP:
	e1 = oa[1];
	e2 = oa[2];
	size = GF_LWX(e1);
	*na = 3 + (size+3)/4;
	//		       no comma
	ProtocolID pt = (ProtocolID)e2;
	tout << pt.Printname() << pregline(oa+3, size);
	break;
    case RnAf_OP:
	e1 = oa[1];
	size = GF_LWX(e1);
	*na = 3 + (size+3)/4;
	//
	tout << foreign_print_image (GF_UPX(e1));
	tout << pregline (oa+2, size);
	break;
    default:
	tout << NotDisAssemble;
	break;
    }
    tout << ";";
    return tout.Result();
}

// char* dis_assemble()
//
// ΥեåȤɤե֥뤷̤ʸ
// ֤
const char*
DisAssembler::dis_assemble()
{
    int cindex	 = offset - &cp->code[0];
    int cbegin = 0;
    int cend   = cp->l_code;
    int obegin = cend;
    int oend   = cp->l_code + cp->l_data;
    int tbegin = oend;
    int tend   = cp->l_code + cp->l_data + cp->l_tmpl;
    int max    = cp->l_total;

    if (cindex >= max) return EndOfCode;
    // ΰ
    if (cbegin != cend && (cbegin <= cindex && cend > cindex)) {
	int newo;
	const char* pi = dis_assemble_code(offset, &newo);
	offset += newo;
	return pi;
    }
    // ֥ΰ
    if (obegin != oend && (obegin <= cindex && oend > cindex))
	return bo_print_image(*offset++);
    // 饹ƥץ졼ΰ
    if (tbegin != tend && (tbegin <= cindex && tend > cindex))
	return class_print_image(*offset++);
    return IllegalCode;
}

// const char* disasm(const Instruction* xo)
//	xo:	եå
//
//  xo Ϳ줿եåȤΥɤե֥뤷̤ʸ
// ˤ֤
const char* disasm(const Instruction* xo)
{
    int newo;
    return dis_assemble_code(xo, &newo);
}

#ifdef PAS_DEBUGGER
#include <stream.h>
extern message_to_Listener(debugger_symbol,unsigned char*);
void print_register(const Instruction* oa,Boolean t = FALSE)
{
    if (!t)return;
    int type;
    char* dp = find_instruction_name(oa[0],(int*)&type);
    if (dp == 0) return;
    Uint e0;
    char mn[BUFSIZ];
    tstream tout = tstream(BUFSIZ,mn);
    switch(type){
    case R1_OP:	    case R1D1_OP:    case R1Da_OP:    case R1Db_OP:
    case R1Dc_OP:   case R1Do_OP:    case R1Vi_OP:    case R1L2_OP:
    case R1Xe_OP:   case R1X1_OP:
	e0 = oa[1];
	tout <<" Reg["<< dec(GF_BY0(e0))<<"] :"<<print(Reg[GF_BY0(e0)]);
	break;
    case R2_OP:	   case R2X1_OP:    case R2D1_OP:    case R2L2_OP:
	e0 = oa[1];
	tout <<" Reg["<< dec(GF_BY0(e0))<<"] :"<<print(Reg[GF_BY0(e0)]);
	tout <<" Reg["<< dec(GF_BY1(e0))<<"] :"<<print(Reg[GF_BY1(e0)]);
	break;
    case R3_OP:
	e0 = oa[1];
	tout <<" Reg["<< dec(GF_BY0(e0))<<"] :"<<print(Reg[GF_BY0(e0)]);
	tout <<" Reg["<< dec(GF_BY1(e0))<<"] :"<<print(Reg[GF_BY1(e0)]);
	tout <<" Reg["<< dec(GF_BY2(e0))<<"] :"<<print(Reg[GF_BY2(e0)]);
	break;
    case R4_OP:
	e0 = oa[1];
	tout <<" Reg["<< dec(GF_BY0(e0))<<"] :"<<print(Reg[GF_BY0(e0)]);
	tout <<" Reg["<< dec(GF_BY1(e0))<<"] :"<<print(Reg[GF_BY1(e0)]);
	tout <<" Reg["<< dec(GF_BY2(e0))<<"] :"<<print(Reg[GF_BY2(e0)]);
	tout <<" Reg["<< dec(GF_BY3(e0))<<"] :"<<print(Reg[GF_BY3(e0)]);
	break;
    case NO_OP:
    default:
	return;
    }
    tout<<'\n';
    tout.Result();
    message_to_Listener(TRECEIVE,(unsigned char*)(tout.Result()));
}
#endif

/*-----------------
 * Local Variables:
 * c-argdecl-indent:4
 * c-indent-level:4
 * c-label-offset:-4
 * c-continued-statement-offset:4
 * End:
 */
