/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// ֥

#include <sys/file.h>
#include <stdio.h>
#include <stream.h>
#include <stdlib.h>
#include <memory.h>
#include <errno.h>
#include "info.h"
#include "aum/alloc.h"
#include "aum/error.h"
#include "loader/mem.h"

extern int yyparse ();

extern	"C" {
    int	    open (const char *n, int m...);
    int	    close (int fd);
    int	    strlen (const char *s);
    int	    strcmp (const char *s1, const char *s2);
}

// line counter
extern int line;

// info table
PidInfop *pid_info_table;
SlotInfop *slot_info_table;
SuperInfop *super_info_table;
ReferInfop *refer_info_table;
MethodInfop *method_info_table;
LabelInfop *label_info_hash;
LabelInfo *label_info_table;
AtomInfop *atom_info_table;
ObjectInfop *object_info_table;
ForeignInfop *foreign_info_table;
int    *tc;

// number of xxx
int	nof_pid;		// number of protocol ID
int	nof_slot;		// number of slot
int	nof_inlet;		// number of inlet slot
int	nof_outlet;		// number of outlet slot
int	nof_super;		// number of super class
int	nof_refer;		// number of reference class
int	nof_method;		// number of method
int	nof_label;		// number of label
int	nof_atom;		// number of atom
int	nof_object;		// number of object
int	nof_foreign;		// number of foreign
int	parse_outlet;		// parsing outlet slot
int	parse_error_count;	// parse error count
int	load_error_flag;	// load error flag
int	cof;			// current code offset

const char *cc_name;		// current class name
const char *cf_name;		// current file name

// assembler input
istream *ain;


static void
gc_info_table1 ()
    //
    // pid_info_table  atom_info_table ǻѤ줿ΰ롣
    // եñ̤˸ƤФ롣
{
    int	    i;
    for (i = 0; i < nof_pid; i++) {	// gc pid info table
	PidInfop pp = pid_info_table[i];
	memoryunsave (pp->label);
	if (pp->name != 0)
	    memoryunsave (pp->name);
	memoryfree (pp, sizeof (PidInfo));
    }
    for (i = 0; i < nof_atom; i++) {	// gc atom info table
	AtomInfop ap = atom_info_table[i];
	memoryunsave (ap->name);
	memoryfree (ap, sizeof (AtomInfo));
    }
}

void
gc_info_table2 ()
    //
    // slot_info_table, super_info_table,  refer_info_table,  method_
    // info_table, label_info_table, object_info_table ǻѤ줿
    // 롣饹ñ̤˸ƤФ롣
{
    int	    i;
    for (i = 0; i < nof_slot; i++) {	// gc slot info table

	SlotInfop sp = slot_info_table[i];
	memoryunsave (sp->name);
	memoryfree (sp, sizeof (SlotInfo));
    }
    for (i = 0; i < nof_super; i++) {	// gc super info table

	SuperInfop up = super_info_table[i];
	memoryunsave (up);
    }
    for (i = 0; i < nof_refer; i++) {	// gc refer info table

	ReferInfop rp = refer_info_table[i];
	memoryunsave (rp->name);
	memoryfree (rp, sizeof (ReferInfo));
    }
    for (i = 0; i < nof_method; i++) {	// gc method info table

	MethodInfop mp = method_info_table[i];
	// label  name  free ʤ
	// pid_info_table  free ˤä free 롣
	memoryfree (mp, sizeof (MethodInfo));
    }
    {
	for (i = 0; i < nof_label; i++) {	// gc label info table

	    LabelInfop lp = &label_info_table[i];
	    memoryunsave (lp->name);
	}
	bzero (label_info_hash, LABLHSZ * sizeof (LabelInfop));
    }
    for (i = 0; i < nof_object; i++) {	// gc object info table

	ObjectInfop op = object_info_table[i];
	StringInfop tp;
	switch (op->type) {
	case OT_STR:
	    tp = op->u.s;
	    PRIVATE_FREE (tp->elements, strlen (tp->elements) + 1);
	    memoryfree (tp, sizeof (StringInfo));
	    memoryfree (op, sizeof (ObjectInfo));
	    break;
	case OT_DFL:
	    memoryfree (op, sizeof (ObjectInfo));
	    break;
	}
    }
    for (i = 0; i < nof_foreign; i++) {
	ForeignInfop fp = foreign_info_table[i];
	memoryfree ((char *) fp->label, strlen (fp->label) + 1);
	memoryfree (fp, sizeof (ForeignInfo));
    }
}

static int
parsing ()
    // {}
    // ȥ꡼ ain Ϳ줿ե򥢥֥뤹롣顼򸡽
    // ϡ-1 ֤
    // {}
{
    int	    status;		// status of yyparse()

    nof_pid = nof_atom = 0;	// ѿν

    parse_error_count = 0;
    load_error_flag = 0;
    line = 1;
    status = yyparse ();	// ʸϴؿθƤӽФ

    gc_info_table1 ();		// ߤβ

    if (parse_error_count > 0 || load_error_flag)
	status = (-1);		// ɻ˥顼ȯ

    return status;
}

static void
allocate_table ()
{
    pid_info_table = (PidInfop *) SHARED_ALLOC (PID_TSZ * sizeof (PidInfop));
    slot_info_table = (SlotInfop *) SHARED_ALLOC (SLOTTSZ * sizeof (SlotInfop));
    super_info_table = (SuperInfop *) SHARED_ALLOC (SUPRTSZ * sizeof (SuperInfop));
    refer_info_table = (ReferInfop *) SHARED_ALLOC (REFRTSZ * sizeof (ReferInfop));
    method_info_table = (MethodInfop *) SHARED_ALLOC (MTHDTSZ * sizeof (MethodInfop));
    label_info_hash = (LabelInfop *) SHARED_ALLOC (LABLHSZ * sizeof (LabelInfop));
    bzero (label_info_hash, LABLHSZ * sizeof (LabelInfop));
    label_info_table = (LabelInfo *) SHARED_ALLOC (LABLTSZ * sizeof (LabelInfo));
    atom_info_table = (AtomInfop *) SHARED_ALLOC (ATOMTSZ * sizeof (AtomInfop));
    object_info_table = (ObjectInfop *) SHARED_ALLOC (OBJCTSZ * sizeof (ObjectInfop));
    foreign_info_table = (ForeignInfop *) SHARED_ALLOC (FLANGSZ * sizeof (ForeignInfop));
    tc = (int *) SHARED_ALLOC (ASCODSZ * sizeof (int));
}

#ifdef PAS_DEBUGGER
void
#else
static void
#endif
deallocate_table ()
{
    SHARED_FREE (tc, ASCODSZ * sizeof (int));
    SHARED_FREE (foreign_info_table, FLANGSZ * sizeof (ForeignInfop));
    SHARED_FREE (object_info_table, OBJCTSZ * sizeof (ObjectInfop));
    SHARED_FREE (atom_info_table, ATOMTSZ * sizeof (AtomInfop));
    SHARED_FREE (label_info_table, LABLTSZ * sizeof (LabelInfo));
    SHARED_FREE (label_info_hash, LABLHSZ * sizeof (LabelInfop));
    SHARED_FREE (method_info_table, MTHDTSZ * sizeof (MethodInfop));
    SHARED_FREE (refer_info_table, REFRTSZ * sizeof (ReferInfop));
    SHARED_FREE (super_info_table, SUPRTSZ * sizeof (SuperInfop));
    SHARED_FREE (slot_info_table, SLOTTSZ * sizeof (SlotInfop));
    SHARED_FREE (pid_info_table, PID_TSZ * sizeof (PidInfop));
}

static int
do_assemble (int fd)
    // {}
    // fd : եǥץͿ줿ե ain Ȥ
    // ֥򤹤롥ɬפʥơ֥Ϥǽ롥
    // {}
{
    char    buf[BUFSIZ];
    filebuf ainfilebuf (fd, buf, BUFSIZ);
    istream ainistream (&ainfilebuf);
    ain = &ainistream;
    allocate_table ();
    int status = parsing ();
    deallocate_table ();
    return status;
}

int
aum_assembler (const char *filename)
    // {}
    // ʸ filename Ϳե AUMLOADPATH 鸫Ĥ롥
    // 顼ˤ -1 ֤ե뤬Ĥʤä
    // ˤϡ³ǽȸʤ 1 ֤˸Ĥäե򥪡
    // ץ󤷥֥뤹롥
    // {}
{
    cf_name = filename; // ե̾Υ
    errno = 0;
    int	    fd = open (filename, O_RDONLY);
    if (errno) {
	cf_name = NULL;
	perror (cf_name);
	return 1;
	// ³ǽǤΤ -1 ֤ʤ
    }
    int status = do_assemble (fd);
    close (fd);
    cf_name = NULL;
    return status;
}

/*-----------------
 * Local Variables:
 * c-argdecl-indent:4
 * c-indent-level:4
 * c-label-offset:-4
 * c-continued-statement-offset:4
 * End:
 */
