/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "table/protocol.h"
#include "aum/fstream.h"
#include "builtin/extern.h"

void doUnGetc_with_fstream(Word x, Word y)
{
    y = Dereference (y);
    if (IsFixnum(y)){
	FileStreamObject* fp = (FileStreamObject*)Pointer(x);
	fp->Ungetc((u_short)Fix2Int(y));
	return;
    }
    error(form("ungetc %s %s ",print(x),print(y)),
	  "Can't coerce %s to INTEGER",print(y));
}

void doUnGetc(Word x, Word y)
    // {} @ METHOD BEGIN
    // {} @ CLASS file
    // {} @ NOTATION X:ungetc(Y)
    // {} @ EXPLANATION
    // Yͤʸ(ASCII)Ȥƥե
    // X˲̤᤹Ȥơ˸ƤФϱ黻ƬʸYʸ
    // ɽƱˤʤ롥
    //
    // աۣøΰʸᤷϤȤϡۤʤä񤤤򤹤롥
    // ȤΤϤ⤷ʸȤƣХȥɡܸˤYͿ줿
    // 硤ᤷϤθ̤٤ʸɤΥХȥʬ
    // ե֤ư뤫Ǥ롥
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsUndefined  (x))
	Sendm_1arg (x, PID_UNGETC, y);
    if (IsFStream(x)){
	doUnGetc_with_fstream(x,y);
    }
    error(form("%s :unget(%s)", print(x), print(y)),
	  CAN_NOT_FIND_METHOD,"unget/+");
}

METHOD(ungetc, R2_OP)
    // {}
    // ungetc Rstream, Rinteger
    // {}
    // Rstream Фʸˤ PUSH ưԤ.
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Word y = Reg[ip->b1];
    doUnGetc (x, y);
    doClose (x);
    doClose (y);
    JumpNextInstruction();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
