/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/fstream.h"
#include "aum/string.h"
#include "builtin/extern.h"

void doPuts_with_fstream(Word x, Word y)
    // {} @ METHOD BEGIN
    // {} @ CLASS file
    // {} @ NOTATION X:puts(Y)
    // {} @ EXPLANATION
    // Yΰ᡼X˽Ϥ롥
    // {} @ METHOD END
{
    y = Dereference (y);

    if (IsASCII_StrObject(y)){
	ASCII_StrObject* a = (ASCII_StrObject*)Pointer(y);
	FileStreamObject_ptr (x)->Puts(a->Print(FALSE));
	doClose(y);
	return;
    }
    if (IsEUC_StrObject(y)){
	EUC_StrObject* e = (EUC_StrObject*)Pointer(y);
	FileStreamObject_ptr (x)->Puts(e->Print(FALSE));
	doClose(y);
	return;
    }
    if (IsUndefined (y)){
	Sendm_1arg (y, PID_REV_PUTS, x);
	return;
    }
    error(form("%s: puts(%s)", print(x), print(y)),
	  form("Can't coernce %s to Srting", print(y)));
    return;
}

void doPuts(Word x, Word y)
{
    x = Dereference (x);
    if (IsFStream(x)){
	doPuts_with_fstream(x,y);
	return;
    }
    if (IsUndefined (x)){
	Sendm_1arg (x, PID_PUTS, y);
	return;
    }
    error(form("%s :puts(%s)", print(x), print(y)),
	  CAN_NOT_FIND_METHOD,"puts/+");
    return;
}

METHOD(puts, R2_OP)
    // {}
    // puts Rstream, Rstring
    // {}
    // [	   address   ]
    // [Rstream|Rstring|00|00]
    // {}
    // Rstream ʸ Rstring Ϥ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Word y = Reg[ip->b1];
    doPuts (x, y);
    doClose (x);

    JumpNextInstruction();
}

void doRevPuts(Word y, Word x)
{
    y = Dereference (y);

    if (IsEUC_StrObject(y)){
	EUC_StrObject* e = (EUC_StrObject*)Pointer(y);
	FileStreamObject_ptr (x)->Puts(e->Print(FALSE));
	return;
    }
    if (IsASCII_StrObject(y)){
	ASCII_StrObject* a = (ASCII_StrObject*)Pointer(y);
	FileStreamObject_ptr (x)->Puts(a->Print(FALSE));
	return;
    }
    error(form("rev_puts %s %s",print(x),print(y)),INVALID_DATA_TYPE,print(y));
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
