/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/fstream.h"
#include "builtin/extern.h"

static void doPutc_with_fstream(Word x, Word y)
    // {} @ METHOD BEGIN
    // {} @ CLASS file
    // {} @ NOTATION X:putc(Y)
    // {} @ EXPLANATION
    // Yͤʸ(ASCII)ȤX˽Ϥ롥
    // {} @ METHOD END
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	FileStreamObject_ptr (x)->Putc (y);
	return;
    }
    if (IsUndefined (y)) {
	Sendm_1arg (y, PID_REV_PUTC, x);
	return;
    }
    error(form("%s:putc(%s)", print(x), print(y)),
	  "Can't coerce %s to INTEGER", print(x));
    return;
}

void doPutc(Word x, Word y)
{
    x = Dereference (x);
    if (IsFStream (x)) {
	doPutc_with_fstream(x,y);
	return;
    }
    if (IsUndefined (x)) {
	Sendm_1arg (x, PID_PUTC, y);
	return;
    }
    error(form("%s:putc(%s)", print(x), print(y)),
	  CAN_NOT_FIND_METHOD,"putc/+");
    return;
}

METHOD(putc, R2_OP)
    // {}
    // putc Rstream, Robject
    // {}
    // [	   address ]
    // [  Rs|  Ro|   0x0000]
    // {}
    // ե Rstream  Robject ʸȤƽϤ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Word y = Reg[ip->b1];
    doPutc (x, y);
    doClose (x);
    doClose (y);
    JumpNextInstruction();
}

void doRevPutc(Word y, Word x)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	FileStreamObject_ptr (x)->Putc (y);
	return;
    }
    error(form("%s:putc(%s) [reverse]", print(x), print(y)),
	  INVALID_DATA_TYPE,print(y));
    return;
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
