/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/fstream.h"
#include "aum/tstream.h"
#include "aum/aumtype.h"
#include "aum/object.h"
#include "aum/string.h"
#include "aum/msgobj.h"
#include "aum/vector.h"
#include "aum/builtin.h"
#include "aum/aj-nc.h"
#include "aum/aj-c.h"
#include "aum/printstack.h"
#include "builtin/extern.h"
#include "table/atomhash.h"

static void Word2String(char buf[], Word x)
{

    if (IsObject(x)){
	Boolean src = ShowRC;
	ShowRC = FALSE;

	switch(Pointer(x)->Type()) {
	case READY:
	case SUSPENDED:
	case SLEEPING:
	case CLOSED:
	    strcpy (buf, Object_ptr(x)->Print());
	    break;

	case ERROR:
	    strcpy (buf, "*Error Object*");
	    break;

	case SINK:
	    strcpy (buf, "*Sink Object*");
	    break;

	case CLASS_OBJ:
	    strcpy (buf, ClassObject_ptr(x)->Print());
	    break;

	case MESSAGE_OBJ:
	    strcpy (buf, MessageObject_ptr(x)->Print());
	    break;

	case FOREIGN_OBJ:
	    strcpy (buf, ForeignObject_ptr(x)->Print());
	    break;

	case MJ_C:
	case MJ_Mut:
	    strcpy (buf, MJ_C_ptr(x)->Print());
	    break;

	case AJ_C:
	    strcpy (buf, AJ_C_ptr (x)->Print ());
	    break;

	case ASCII_STR:
	    strcpy (buf, ASCII_StrObject_ptr(x)->Print(FALSE));
	    break;

	case EUC_STR:
	    strcpy (buf, EUC_StrObject_ptr(x)->Print(FALSE));
	    break;

	case MJ_NC:
	    strcpy (buf, MJ_NC_ptr(x)->Print());
	    break;

	case MJ_W:
	    strcpy (buf, MJ_W_ptr(x)->Print());
	    break;

	case GARBAGE:
	    strcpy (buf, "*GARBAGE*");
	    break;

	case TRACE_INLET:
	    strcpy (buf, "CONNECTED");

	case AJ_NC:
	    strcpy (buf, AJ_NC_ptr(x)->Print());
	    break;

	case IMP_OBJ:
	    strcpy (buf, MJ_IMP_OBJ_ptr(x)->Print());
	    break;

	case IMP_OBJ_NT:
	    strcpy (buf, MJ_IMP_OBJ_NT_ptr(x)->Print());
	    break;

	case IMP_INLET:
	    strcpy (buf, MJ_IMP_INLET_ptr(x)->Print());
	    break;

	case IMP_OUTLET:
	    strcpy (buf, MJ_IMP_OUTLET_ptr(x)->Print());
	    break;

	case DFLOAT:
	    sprintf (buf, "%g", Double2double (x));
	    break;

	default:
	    strcpy (buf, "*BUILTIN-ERROR*");
	    break;
	}
	ShowRC = src;
	return;
    }

    if (IsAtom(x)) {
	strcpy (buf, AtomPrintname(x));
	return;
    }

    if (IsFixnum(x)) {
	sprintf (buf, "%d", Fix2Int (x));
	return;
    }

    if (IsSFloat(x)){
	sprintf (buf, "%g", Single2float(x));
	return;
    }

    if (IsBool(x)){
	if (IsTrue(x))
	    strcpy (buf, "`true");
	else
	    strcpy (buf, "`false");
	return;
    }
    strcpy (buf, "*BUILTIN-ERROR*");
}

void doPut(Word x, Word y)
    // {} @ METHOD BEGIN
    // {} @ CLASS file
    // {} @ NOTATION X:put(Y)
    // {} @ EXPLANATION
    // ֥Yΰ᡼X˽Ϥ롥
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsFStream(x)) {
	y = Dereference (y);
	if (IsUndefined (y))
	    Sendm_1arg (y, PID_REV_PUT, x);
	else {
	    char buf[BUFSIZ];
	    Word2String (buf, y);
	    FileStreamObject_ptr (x)->Puts (buf);
	}
	return;
    }
    if (IsUndefined (x)) {
	Sendm_1arg (x, PID_PUT, y);
	return;
    }
    error(form("%s :put(%s)",print(x), print(y)),INVALID_DATA_TYPE, print(x));
    return;
}

METHOD(put, R2_OP)
    // {}
    // put Rstream, Robject
    // {}
    // [	   address ]
    // [  Rs|  Ro|   0x0000]
    // {}
    // Rstream  Robject Ϥ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Word y = Reg[ip->b1];
    doPut (x, y);
    doClose (x);
    doClose (y);
    JumpNextInstruction();
}

void doRevPut (Word y, Word x)
{
    y = Dereference (y);
    char buf[BUFSIZ];
    Word2String (buf, y);
    FileStreamObject_ptr (x)->Puts (buf);
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
