/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/fstream.h"
#include "aum/compare.h"
#include "aum/string.h"
#include "table/protocol.h"
#include "builtin/extern.h"

extern int IsConvertableASCII (Word x);
extern Word CreateFileStream (const char *x, const char *y);

static char *
toCstring (Word & x)
{
    if (IsASCII_StrObject (x))
	return ASCII_StrObject_ptr (x)->new_C_string ();
    else
	return EUC_StrObject_ptr (x)->new_C_string ();
}

Word
doOpen_with_asciistr (Word ax, Word ay)
    // {}
    // ӣãɣʸǼե̾ǥ֥ y Ǽ
    // ⡼ɤǡե򥪡ץ󤹤롥
    // {}
{
    Word y = Dereference (ay);
    if (IsASCII_StrObject (y))
	return CreateFileStream (toCstring (ax), toCstring (y));

    if (IsEUC_StrObject (y)) {
	if (IsConvertableASCII (y))
	    return CreateFileStream (toCstring (ax), toCstring (y));
	else {
	    error (form ("#file_stream:open(%s,%s,^Z)", print (ax), print (ay)),
		   "mode string %s is NON-ASCII string", print (ay));
	    return SINKOBJ;
	}
    }
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_OPEN, ax);

    error (form ("#file_stream:open(%s,%s,^Z)", print (ax), print (ay)),
	   INVALID_DATA_TYPE, print (y));
    return SINKOBJ;
}

Word
doOpen (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS filemake
    // {} @ NOTATION #file:open(X,Y,^Z)
    // {} @ EXPLANATION
    // ̾XΥե⡼Yǳƿե륪
    // ȤZ³롥X YʸǤʤƤϤʤʤ⡼Y
    // ϰʲΰ̣ġ
    // @table @code
    // @item "r"
    // ɤ߹ߤǥե򳫤
    // @item "w"
    // 񤭹ߤǥե򳫤
    // @item "a"
    // ɲý񤭹ߤǥե򳫤
    // @item "r+"
    // ɤ߹ߡ񤭹ߤξǥե򳫤եΰ֤ƬȤʤ롥
    // @item "w+"
    // ɤ߹ߡ񤭹ߤξǥե򳫤եϿ
    // 뤫ޤ礭Ȥʤ롥
    // @item "a+"
    // ɤ߹ߡ񤭹ߤξǥե򳫤եΰ֤Ȥʤ롥
    // @end table
    // X뤤 Y ̤³Υ祤Ȥξ硤³ޤԤġ
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    Word z;

    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case ASCII_STR:
	    z = doOpen_with_asciistr (x, ay);
	    break;
	case EUC_STR:
	    if (IsConvertableASCII (x))
		z = doOpen_with_asciistr (x, ay);
	    else {
		error (form ("file:open(%s,%s,^Z)", print (ax), print (ay)),
		       "filename %s is NON-ASCII string", print (ax));
		z = SINKOBJ;
	    }
	    break;
	case JOINT:
	case OBJECT:
	    z = SendBuiltinMessage2 (x, PID_OPEN, ay);
	    break;

	case WC_ASCII_STR:
	    z = ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_OPEN, ay);
	    break;

	case WC_EUC_STR:
	    z = EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_OPEN, ay);
	    break;

	default:
	    goto error_occurred;
	}
    }
    else if (IsSink (x)) {
	z = SINKOBJ;
    }
    else {
    error_occurred:
	error (form("file:open(%s,%s,^Z)",print (x),print(ay)),
	       CAN_NOT_FIND_METHOD,"open/++-");
	return INT0;
    }
    doClose (ay);
    return z;
}

METHOD (fopen, R3_OP)
    // {}
    // open Rfilename, Rmode, Rstream
    // {}
    // [	   address ]
    // [  Rf|  Rm|  Rs|	 00]
    // {}
    // Rfilename Υե Rmode ǥץ󤷡Rstream 
    // ե륹ȥ꡼Ǽ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b2] = doOpen (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevOpen (Word y, Word x)
    // {}
    // ӣãɣʸǼե̾ǥ֥ y Ǽ
    // ⡼ɤǡե򥪡ץ󤹤롥
    // {}
{
    return doOpen (x, y);
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
