/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/word.h"
#include "aum/protocolid.h"
#include "aum/fstream.h"
#include "builtin/extern.h"

Word doIsEof(Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS file
    // {} @ NOTATION X:iseof(^Y)
    // {} @ EXPLANATION
    // Xξ֤ @code{EOF} (end of file) ɤ
    // 롥⤷@code{EOF} ʤ @code{`true} 򤽤Ǥʤ
    // @code{`false} 򥹥ȥ꡼Y³롥
    // {} @ METHOD END
{
    x = Dereference (x);
    switch(Type_of(x)){
    case AUm_Object:
	switch(Pointer(x)->Type()){
	case FILE_STREAM:
	    FileStreamObject* fstr = (FileStreamObject*)Pointer(x);
	    return fstr->Iseof();
	case MJ_NC:
	case AJ_NC:
	case MJ_W:
	case IMP_OBJ:
	case IMP_OBJ_NT:
	case IMP_INLET:
	case IMP_OUTLET:
	    return SendBuiltinMessage1(x,PID_ISEOF);
	default:
	    break;
	}
	break;
    default:
	break;
    }
    error (form("%s:iseof(^Y)",print(x)),CAN_NOT_FIND_METHOD,"iseof/-");
    //"Can't coerce %s to FILE STREAM",print(x));
    return INT0;
}

METHOD(iseof, R2_OP)
    // {}
    // iseof Rstream, Rresult
    // {}
    // Rstream Υե륹ȥ꡼४֥Ȥ
    // EOFǤ `true 򤽤Ǥʤ `false ֤
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doIsEof (x);
    doClose (x);
    JumpNextInstruction();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
