/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/stdlib.h"
#include "aum/fetch.h"
#include "aum/fstream.h"
#include "aum/protocolid.h"
#include "builtin/extern.h"

Word doGetc(Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS file
    // {} @ NOTATION X:getc(^Y)
    // {} @ EXPLANATION
    // X飱ʸϤȥ꡼Y³롥Y
    // ΥǡȤʤ롥
    // {} @ METHOD END
{
    x = Dereference (x);
    if(IsUndefined  (x)){
	SendBuiltinMessage1(x,PID_GETC);
    }
    if (IsFStream(x))
	return FileStreamObject_ptr(x)->Getc();
    error (form("%s:getc(^Y)",print(x)),
	   CAN_NOT_FIND_METHOD,"getc/-");
    return INT0;
}

METHOD(getc, R2_OP)
    // {}
    // getc Rstream, Rinteger
    // {}
    // [	   address   ]
    // [Rstream|  Rchar|00|00]
    // {}
    //	Rstream ʸ͡ʸɡˤɤ߹ Rinteger Ȥ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doGetc (x);
    doClose (x);
    JumpNextInstruction();
}
/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
